/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// Studio580.h                                                             //
//                                                                         //
// Provides incomplete type specifications for all classes in Studio580.   //
// Defines "lightweight types" (enums, structs, and typedefs) used         //
// throughout the Studio580 system.                                        //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//  <unversioned module>                                                   //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// Copyright (c) 2008 Lucas Stephen Beeler. All rights reserved.           //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef STUDIO_580_TYPES__HXX
#define STUDIO_580_TYPES__HXX

#include <ColorImaging.h>

//--------------------------------------------------------------------------//
// INCOMPLETE TYPE SPECIFICATIONS                                           //
//--------------------------------------------------------------------------//
class  Brush;
class  BrushManager;
class  S580MainWinController;
class  S580AppController;
class  NewDialogController;
class  PaintingDocument;
class  EraserOptionsDialog;
class  Eraser;
class  BrushOptionsDialog;
class  UndoPoint;
//--------------------------------------------------------------------------//



//--------------------------------------------------------------------------//
// LIGHTWEIGHT TYPES                                                        //
//--------------------------------------------------------------------------//
enum  ToolSpecifier { kBrushTool, kEraserTool };
//--------------------------------------------------------------------------//

#endif
