/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// S580MainWindow.h                                                        //
//                                                                         //
// Packages the interface definition of class S580MainWinController only   //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//  <unversioned module>                                                   //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// Copyright (c) 2008 Lucas Stephen Beeler. All rights reserved.           //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef S580_MAIN_WINDOW__HXX
#define S580_MAIN_WINDOW__HXX

#include <ColorImaging.h>
#include <memory>
#include <vector>
#include "Studio580Types.h"

class S580MainWinController :
    public virtual  ApplicationWindowController,
    public virtual  GLCanvasController {

private:

    std::auto_ptr<ApplicationWindowThingy>    fView;
    std::auto_ptr<GLCanvasThingy>             fRenderingCanvas;
    S580AppController*                        fParent;
    StatusBarPaneToken                        fBrushStatPane;
    StatusBarPaneToken                        fEraserStatPane;
    ToolbarButtonToken                        fBrushToolButton;
    ToolbarButtonToken                        fBrushOptsButton;
    ToolbarButtonToken                        fEraserToolButton;
    ToolbarButtonToken                        fEraserOptsButton;
    bool                                      fIsScrollTrackInProgress;
    ScrollbarSelector                         fTrackingScroll;
    int                                       fScrollTrackValue;
    bool                                      fIsPixWriteRequired;
    bool                                      fIsEraseOpRequired;
    Vector2Di                                 fErasePoint;
    bool                                      fIsBrushDrawRequired;

    void          uConfigureToolbar( );
    void          uSyncMenuState( );
    void          uSyncStatusBarText( );
    void          uSyncScrollbars( );
    void          uDrawCanvasFrame( );
    void          uDrawSampleContent( );
    int           uGetBottomRelScrollPos( ) const;
    void          uSetContentConstraints( );
    void          uUnsetContentConstraints( );
    void          uWritePixelsToDocument( );
    void          uDrawPixelsFromDocument( );
    void          uRunSaveInteraction( );
    Vector2Di     uGetViewfinderOrigin( ) const;
    Vector2Di     uGetViewfinderExtent( ) const;
    Rectangle2Di  uGetConstrainedViewport( ) const;
    Rectangle2Di  uGetVisibleSubcanvas( ) const;
    void          uSyncTitleBarText( );


public:

    static  const unsigned short  kCanvasGutterWidth = 96;
    static  const RGBColor        kCanvasGutterColor;

    S580MainWinController(S580AppController& parent);
    virtual ~S580MainWinController( );

    void  thingyClosed(ApplicationWindowThingy&);
    void  thingyMaximized(ApplicationWindowThingy&);
    void  thingyRestored(ApplicationWindowThingy&);
    void  thingyMenuItemChosen(ApplicationWindowThingy&, int);
    void  thingyToolbarButtonPushed(ApplicationWindowThingy&,
        ToolbarButtonToken);
    void  thingyToolbarButtonSelected(ApplicationWindowThingy&,
        ToolbarButtonToken);
    void  thingyToolbarButtonDeselected(ApplicationWindowThingy&,
        ToolbarButtonToken);
    void  thingySized(ApplicationWindowThingy&);
    void  thingyScrollbarPositioned(ApplicationWindowThingy&,
        const ScrollbarSelector&);
    void  thingyScrollbarTracked(ApplicationWindowThingy&,
        const ScrollbarSelector&, int);

    void  layoutSubthingies(CompositeThingy& sender);
    void  enableSubthingies(CompositeThingy& sender);
    void  disableSubthingies(CompositeThingy& sender);

    void  imageThingy(GLCanvasThingy&);
    void  thingySized(GLCanvasThingy&);
    void  initializeThingy(GLCanvasThingy&);
    void  thingyMousePressed(GLCanvasThingy&, const MouseInteractionToken&);
    void  thingyMouseReleased(GLCanvasThingy&, const MouseInteractionToken&);
    void  thingyMouseTracked(GLCanvasThingy&, const MouseInteractionToken&);

    virtual  void  showView( );
    virtual  S580AppController&  parent( );
    virtual  const S580AppController&  parent( ) const;
    virtual  ApplicationWindowThingy&  view( );
    virtual  const ApplicationWindowThingy&  view( ) const;
    virtual  void  setSelectedTool(const ToolSpecifier&);

    virtual  void  notifyDocumentChanged( );
    virtual  void  notifyDocumentStateChanged( );
    virtual  void  notifyEraserChanged( );
    virtual  void  notifyBrushChanged( );

    virtual  GPUInterface&  gpuInterface( );
    virtual  void  runSaveInteraction( );
};

#endif
