/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// NewDialog.h                                                             //
//                                                                         //
// Packages the interface definition of class NewDialogController only     //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//  <unversioned module>                                                   //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// Copyright (c) 2008 Lucas Stephen Beeler. All rights reserved.           //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef NEW_DIALOG__HXX
#define NEW_DIALOG__HXX

#include <ColorImaging.h>
#include "Studio580Types.h"
#include <memory>

class NewDialogController
    : public virtual DialogController {

private:

    S580AppController*             fParent;
    std::auto_ptr<DialogThingy>    fView;
    Vector2Di                      fUserImageDimension;
    bool                           fWasDataCaptured;

public:

    static  const unsigned short  kMinimumImageDimension = 320;
    static  const unsigned short  kMaximumImageDimension = 1920;
    static  const unsigned short  kDefaultImageDimension = 512;

    NewDialogController(S580AppController& parent);
    virtual ~NewDialogController( );

    void  layoutSubthingies(CompositeThingy& sender);
    void  enableSubthingies(CompositeThingy& sender);
    void  disableSubthingies(CompositeThingy& sender);

    void  thingyItemActivated(DialogThingy&, int);
    void  thingyClosed(DialogThingy&);
    void  thingyInteractionStarted(DialogThingy&);
    void  thingyInteractionStopped(DialogThingy&);

    bool  runInteraction(Vector2Di&);
    S580AppController&  parent( );
    DialogThingy&  view( );
};

#endif
