//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// EraserF.glsl                                                             //
//                                                                          //
// Fragment shader that controls the appearance of the eraser footprint.    //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// ver 1.0.0 of Fri 09-Jan-2009 @ 4:34am EST                                //
//                                                                          //
//    initial revision                                                      //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// Copyright (c) 2008-2009, Lucas Stephen Beeler. All Rights Reserved.      //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////



//-------------------------------------------------------------------------//
// UNIFORMS                                                                //
//-------------------------------------------------------------------------//
uniform  float      Radius;
uniform  float      NumBlendPixels;
uniform  sampler2D  NoiseTex;
uniform  bool       IsNoiseEnabled;
//-------------------------------------------------------------------------//




//-------------------------------------------------------------------------//
// main ( )                                                                //
//-------------------------------------------------------------------------//
void  main( )
{
    vec2  thisloc = gl_TexCoord[0].st;    
    float distctr = length(thisloc);
    
    float  alpha;
    if (distctr > (Radius - NumBlendPixels)) {
    
        float overdist = distctr - (Radius - NumBlendPixels);
        alpha = overdist / NumBlendPixels;
        alpha = smoothstep(1.0, 0.0, alpha);

        if (IsNoiseEnabled) {
    
            vec2  samplept = vec2(cos(gl_FragCoord.s), sin(gl_FragCoord.t));
            alpha = alpha - (1.0 - alpha) * texture2D(NoiseTex, samplept).r;
        }
    }
    else {
    
        alpha = 1.0;
    }
        
    gl_FragColor = vec4(1.0, 1.0, 1.0, alpha);
}
//-------------------------------------------------------------------------//
