/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// EraserOptionsDialog.h                                                   //
//                                                                         //
// Packages the interface definition of class EraserOptionsDialog only     //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//  <unversioned module>                                                   //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// Copyright (c) 2008 Lucas Stephen Beeler. All rights reserved.           //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef  ERASER_OPTIONS_DIALOG__HXX
#define  ERASER_OPTIONS_DIALOG__HXX

#include "Studio580Types.h"
#include "Erasers.h"

class EraserOptionsDialog
    : public virtual DialogController {

private:

    S580AppController*             fParent;
    std::auto_ptr<DialogThingy>    fView;
    bool                           fWasCanceled;
    Eraser                         fTargetEraser;

    void  uSyncCrossSecReadout( );
    int   uGetCrossSecWidth( );
    void  uInitCrossSecAssembly( );
    void  uSyncBlendPixReadout( );
    int   uGetBlendPix( );
    void  uInitBlendPixAssembly( );
    void  uSyncBlendToCrossSec( );
    bool  uGetEdgeNoise( );
    void  uInitEdgeNoise( );

public:

    EraserOptionsDialog(S580AppController&);
    virtual ~EraserOptionsDialog( );

    void  layoutSubthingies(CompositeThingy& sender);
    void  enableSubthingies(CompositeThingy& sender);
    void  disableSubthingies(CompositeThingy& sender);
    void  thingyItemActivated(DialogThingy&, int);
    void  thingyClosed(DialogThingy&);
    void  thingyInteractionStarted(DialogThingy&);
    void  thingyInteractionStopped(DialogThingy&);

    bool  runInteraction(Eraser&);
    S580AppController&  parent( );
    DialogThingy&  view( );
};

#endif
