/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// EraserOptionsDialog.cpp                                                 //
//                                                                         //
// Implements methods in class EraserOptionsDialog only                    //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//  <unversioned module>                                                   //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// Copyright (c) 2008 Lucas Stephen Beeler. All rights reserved.           //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#include "EraserOptionsDialog.h"
#include "S580Application.h"
#include "resource.h"
#include <sstream>

EraserOptionsDialog::EraserOptionsDialog(S580AppController& parent)
    : fParent(&parent)
{
    fView.reset(new DialogThingy(parent.mainWindowView( ),
        kEraserOptsDialogID));
    delete & fView->installController(*this);
}



EraserOptionsDialog::~EraserOptionsDialog( )
{
}



void  EraserOptionsDialog::layoutSubthingies(CompositeThingy& sender)
{
}



void  EraserOptionsDialog::enableSubthingies(CompositeThingy& sender)
{
}



void  EraserOptionsDialog::disableSubthingies(CompositeThingy& sender)
{
}



void  EraserOptionsDialog::thingyItemActivated(DialogThingy& sender,
    int itemID)
{
    if (itemID == IDOK) {

        sender.stopInteraction( );
    }
    else if (itemID == IDCANCEL) {

        fWasCanceled = true;
        sender.stopInteraction( );
    }
    else if (itemID == kCrossSecWidthSliderID) {

        uSyncCrossSecReadout( );
        uSyncBlendToCrossSec( );
        fTargetEraser.setWidth(uGetCrossSecWidth( ));
        fTargetEraser.setBlendPixels(uGetBlendPix( ));
    }
    else if (itemID == kBlendRegionSliderID) {

        uSyncBlendPixReadout( );
        fTargetEraser.setBlendPixels(uGetBlendPix( ));
    }
    else if (itemID == kEdgeNoiseCheckboxID) {

        if (uGetEdgeNoise( ) == true)
            fTargetEraser.enableEdgeNoise( );
        else
            fTargetEraser.disableEdgeNoise( );

    }
}



void  EraserOptionsDialog::thingyClosed(DialogThingy&)
{
}



void  EraserOptionsDialog::thingyInteractionStarted(DialogThingy& sender)
{
    sender.themeItem(kCrossSecWidthGroupID);
    sender.themeItem(kCrossSecWidthReadoutID);
    sender.themeItem(kBlendRegionSizeGroupID);
    sender.themeItem(kBlendRegionSizeReadoutID);
    sender.themeItem(kAppearanceOptsGroupID);
    sender.themeItem(kEdgeNoiseCheckboxID);
    sender.themeItem(IDOK);
    sender.themeItem(IDCANCEL);

    uInitCrossSecAssembly( );
    uSyncCrossSecReadout( );

    uInitBlendPixAssembly( );
    uSyncBlendPixReadout( );

    uInitEdgeNoise( );
}



void  EraserOptionsDialog::thingyInteractionStopped(DialogThingy&)
{
}



bool  EraserOptionsDialog::runInteraction(Eraser& eraser)
{
    fWasCanceled = false;
    fTargetEraser = eraser;

    view( ).startInteraction( );

    if (! fWasCanceled)
        eraser = fTargetEraser;

    return (! fWasCanceled);
}



S580AppController&  EraserOptionsDialog::parent( )
{
    return *fParent;
}



DialogThingy&  EraserOptionsDialog::view( )
{
    return *fView;
}



void  EraserOptionsDialog::uSyncCrossSecReadout( )
{
    std::ostringstream readoutstr;

    readoutstr << uGetCrossSecWidth( ) << " px";

    HWND  readouthandle = GetDlgItem(view( ).adapter( ).primitive( ),
        kCrossSecWidthReadoutID);

    Win32Tools::setWindowTextString(readouthandle, readoutstr.str( ));
}



int   EraserOptionsDialog::uGetCrossSecWidth( )
{
    HWND  sliderhandle = GetDlgItem(view( ).adapter( ).primitive( ),
        kCrossSecWidthSliderID);

    return 2 * SendMessage(sliderhandle, (UINT) TBM_GETPOS, 0, 0);
}



void   EraserOptionsDialog::uInitCrossSecAssembly( )
{
    HWND  sliderhandle = GetDlgItem(view( ).adapter( ).primitive( ),
        kCrossSecWidthSliderID);

    SendMessage(sliderhandle, (UINT) TBM_SETRANGEMIN, (WPARAM) FALSE,
        (LPARAM) 2);
    SendMessage(sliderhandle, (UINT) TBM_SETRANGEMAX, (WPARAM) FALSE,
        (LPARAM) 64);
    SendMessage(sliderhandle, (UINT) TBM_SETTICFREQ, (WPARAM) 4,
        (LPARAM) 0);
    SendMessage(sliderhandle, (UINT) TBM_SETPOS, (WPARAM) TRUE,
        (LPARAM) fTargetEraser.width( ) / 2);
}



void  EraserOptionsDialog::uSyncBlendPixReadout( )
{
    std::ostringstream readoutstr;

    readoutstr << uGetBlendPix( ) << " px";

    HWND  readouthandle = GetDlgItem(view( ).adapter( ).primitive( ),
        kBlendRegionSizeReadoutID);

    Win32Tools::setWindowTextString(readouthandle, readoutstr.str( ));
}



int   EraserOptionsDialog::uGetBlendPix( )
{
    HWND  sliderhandle = GetDlgItem(view( ).adapter( ).primitive( ),
        kBlendRegionSliderID);

    return SendMessage(sliderhandle, (UINT) TBM_GETPOS, 0, 0);
}



void  EraserOptionsDialog::uInitBlendPixAssembly( )
{
    int  minpos = 1;
    int  maxpos = uGetCrossSecWidth( ) / 4;

    HWND  sliderhandle = GetDlgItem(view( ).adapter( ).primitive( ),
        kBlendRegionSliderID);

    SendMessage(sliderhandle, (UINT) TBM_SETRANGEMIN, (WPARAM) FALSE,
        (LPARAM) minpos);
    SendMessage(sliderhandle, (UINT) TBM_SETRANGEMAX, (WPARAM) FALSE,
        (LPARAM) maxpos);
    SendMessage(sliderhandle, (UINT) TBM_SETPOS, (WPARAM) TRUE,
        (LPARAM) fTargetEraser.blendPixels( ));
}



void  EraserOptionsDialog::uSyncBlendToCrossSec( )
{
    int  blendmin = 1;
    int  blendmax = uGetCrossSecWidth( ) / 4;

    int  blendpix = clamp(uGetBlendPix( ), blendmin, blendmax);

    HWND  sliderhandle = GetDlgItem(view( ).adapter( ).primitive( ),
        kBlendRegionSliderID);

    SendMessage(sliderhandle, (UINT) TBM_SETRANGEMIN, (WPARAM) TRUE,
        (LPARAM) blendmin);
    SendMessage(sliderhandle, (UINT) TBM_SETRANGEMAX, (WPARAM) TRUE,
        (LPARAM) blendmax);
    SendMessage(sliderhandle, (UINT) TBM_SETPOS, (WPARAM) TRUE,
        (LPARAM) blendpix);

    if (blendmin == blendmax)
        view( ).disableItem(kBlendRegionSliderID);
    else
        view( ).enableItem(kBlendRegionSliderID);

    std::ostringstream readoutstr;

    readoutstr << blendpix << " px";

    HWND  readouthandle = GetDlgItem(view( ).adapter( ).primitive( ),
        kBlendRegionSizeReadoutID);

    Win32Tools::setWindowTextString(readouthandle, readoutstr.str( ));
}




bool  EraserOptionsDialog::uGetEdgeNoise( )
{
    HWND  checkbutton = GetDlgItem(view( ).adapter( ).primitive( ),
        kEdgeNoiseCheckboxID);

    LRESULT checkstate = SendMessage(checkbutton, (UINT) BM_GETCHECK, 0, 0);

    if (checkstate == BST_CHECKED)
        return true;
    else
        return false;
}



void  EraserOptionsDialog::uInitEdgeNoise( )
{
    HWND  checkbutton = GetDlgItem(view( ).adapter( ).primitive( ),
        kEdgeNoiseCheckboxID);

    if (fTargetEraser.isEdgeNoiseEnabled( ))
        Win32Tools::checkButton(checkbutton);
    else
        Win32Tools::uncheckButton(checkbutton);
}
