//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// WorkPane.h                                                               //
//                                                                          //
// Pacakges the definitons of class WorkPaneView and the WorkPaneController //
// interface.                                                               //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// ver. 2.1.6 of Fri 3 May 2008 @ 7:56pm EDT                                //
//                                                                          //
//     changed all references of class template Vertex2D to Vector2D; see   //
//     the AffineGeometry module's header for more info                     //
//                                                                          //
// ver. 2.1.5 of Wed 26-Mar-2008 @ 5:48pm EDT                               //
//                                                                          //
//    Added UIComponent enable/disable management support to WorkPane views //
//    and controllers.                                                      //
//                                                                          //
// ver. 2.1.0 of Fri 07-Mar-2008 @ 3:31pm EST                               //
//                                                                          //
//    Added the new InsetWorkPaneView class. Class WorkPaneView modified to //
//    support configurable background coloring.                             //
//                                                                          //
// ver. 2.0.0 of Fri 16-Feb-2008 @ 12:27am EST                              //
//                                                                          //
//    This file has been around for months and has seen several evolutions  //
//    through CVS commit cycles in projects GPUISupport, PyramidBuilder,    //
//    and Synthesizer. However this current version 2.0.0 is the first      //
//    formal "version" of the file and is considered stable.                //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// Copyright (c) 2007-2008 Lucas Stephen Beeler. All Rights Reserved.       //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#ifndef WORK_PANE__HXX
#define WORK_PANE__HXX

#include <PTCITypes.h>
#include <Win32Support.h>
#include <AffineGeometry.h>
#include <UserInteraction.h>
#include <set>
#include <map>

//--------------------------------------------------------------------------//
// CLASS  WorkPaneView                                                      //
//--------------------------------------------------------------------------//
class  WorkPaneView
    : public virtual UIComponentView {

protected:

    static  const unsigned short  kDefaultWidth = 160;
    static  const unsigned short  kDefaultHeight = 90;
    static  const Vector2Di       kDefaultPosition;
    static  const std::string     kWindowClassName;

    static  bool  sIsWindowClassRegistered;
    static  std::map<HWND, WorkPaneView*>  sObjectMap;
    static  WorkPaneView*  sObjAwaitingInit;

    static LRESULT WINAPI sWindowProc(HWND targetWindow, UINT messageCode,
        WPARAM wParam, LPARAM lParam);
    static  void  sRegisterWindowClass( );

    HWND                  fWindowPrimitive;
    WorkPaneController*   fController;
    std::set<HWND>        fChildSet;
    std::set<HWND>        fAutoEnableSet;
    HBRUSH                fBackgroundBrush;
    COLORREF              fBackgroundSolid;
    WindowBackgroundKind  fBackground;

    virtual  LRESULT  uProcessWindowMessage(HWND targetWindow,
        UINT messageCode, WPARAM wParam, LPARAM lParam);

    WorkPaneView( )
        : fWindowPrimitive(0),
          fBackgroundBrush(GetSysColorBrush(COLOR_BTNFACE)),
          fBackground(kStandardControlBackground),
          fBackgroundSolid(GetSysColor(COLOR_BTNFACE)) { }

public:

    static  const unsigned short  kChildID0 = 2048;

    WorkPaneView(HWND parent, unsigned short childID);
    virtual ~WorkPaneView( );
    
    virtual  unsigned short  width( ) const;
    virtual  void  setWidth(unsigned short w);
    virtual  unsigned short  height( ) const;
    virtual  void  setHeight(unsigned short h);
    virtual  Vector2Di  position( ) const;
    virtual  void  setPosition(const Vector2Di& p);
    virtual  void  setPosition(unsigned short x, unsigned short y);
    virtual  HWND  peerHandle( );
    virtual  void  invalidate( );
    virtual  unsigned short  clientWidth( ) const;
    virtual  unsigned short  clientHeight( ) const;
    virtual  void  show( );
    virtual  void  hide( );
    virtual  bool  isVisible( ) const;
    virtual  void  enable( );
    virtual  void  disable( );
    virtual  bool  isEnabled( ) const;
    virtual  void  manageChild(HWND c);
    virtual  void  unmanageChild(HWND c);
    virtual  bool  isChildManaged(HWND c) const;
    virtual  WorkPaneController&  controller( );
    virtual  WorkPaneController&  installController(WorkPaneController& c);
    virtual  WindowBackgroundKind  backgroundKind( ) const;
    virtual  void  setBackgroundKind(WindowBackgroundKind bgk);
};
//--------------------------------------------------------------------------//




//--------------------------------------------------------------------------//
// CLASS  InsetWorkPaneView                                                 //
//--------------------------------------------------------------------------//
class  InsetWorkPaneView
    : public virtual WorkPaneView {

public:

    InsetWorkPaneView(HWND parent, unsigned short childID);
    virtual ~InsetWorkPaneView( );
};
//--------------------------------------------------------------------------//




//--------------------------------------------------------------------------//
// CLASS  WorkPaneController                                                //
//--------------------------------------------------------------------------//
class  WorkPaneController
    : UIComponentController {

protected:

    WorkPaneController( );

public:

    static  WorkPaneController*  nullController( );

    virtual ~WorkPaneController( );

    virtual  void  installed(WorkPaneView& sender) = 0;
    virtual  void  deinstalled(WorkPaneView& sender) = 0;
    virtual  void  layout(WorkPaneView& sender) = 0;
    virtual  void  commandPropagated(WorkPaneView& sender,
        HWND commandSource, unsigned short commandID) = 0;
    virtual  void  viewEnabled(UIComponentView& sender) = 0;
    virtual  void  viewDisabled(UIComponentView& sender) = 0;
};
//--------------------------------------------------------------------------//

#endif
