//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// Win32Support.h                                                           //
//                                                                          //
// #defines preprocessor macros and includes headers in the correct order   //
// to enable compilation of PTCI-based code on NT-based Win32 platforms.    //
// Also defines the Win32Tools class, which wraps a number of functions     //
// useful for using the PTCI classes on Win32 platforms.                    //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// ver. 2.10.0 of Sat 18 Oct 2008 @ 9:02pm EDT                              //
//                                                                          //
//     Added method doesFileExist( ) to class Win32Tools::Filesystem        //
//                                                                          //
// ver. 2.9.1 of Tue 20 May 2008 @ 2:38pm EDT                               //
//                                                                          //
//     makeBoldLabel( ) in Win32Tools WidgetFactory now creates a hidden    //
//     widget (i.e. the WS_VISIBLE style flag is no longer set).            //
//                                                                          //
//  older versions:                                                         //
//                                                                          //
//      older change history elided; check out an older CVS rev to get it   //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// Copyright (c) 2007-2008, Lucas Stephen Beeler. All Rights Reserved.      //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#ifndef  WIN32_TOOLS__HXX
#define  WIN32_TOOLS__HXX

#undef UNICODE
#define GL_GLEXT_PROTOTYPES
#include "AffineGeometry.h"
#include <windows.h>
#include <commctrl.h>
#include <GL/glew.h>
#include <GL/wglew.h>
#include <string>
#include <cmath>

class  RGBAImage;
struct RGBColor;

typedef DWORD RGBColorNative;

enum  WindowBackgroundKind { kStandardControlBackground, kWhiteBackground };

class Win32Tools {

public:

    class Filesystem {

        friend  class Win32Tools;

    private:

        Filesystem( );

    public:

        static  std::string  extractDirectory(const std::string& path);
        static  std::string  extractFilename(const std::string& path);

        virtual  ~Filesystem( );

        bool         doesFileExist(const std::string& file);
        bool         doesDirectoryExist(const std::string& dir);
        void         createDirectory(const std::string& dir);
        time_t       modificationTime(const std::string& path);
        std::string  mapTextFile(const std::string& path, int maxlines = -1);
        std::string  cwd( );
    };

    class WidgetFactory {

        friend class Win32Tools;

    private:

        static  const std::string  kSeparatorClassName;

        WidgetFactory( );

    public:

        virtual  ~WidgetFactory( );

        HWND  makePushButton(HWND parent, long long id);
        HWND  makeDefaultPushButton(HWND parent, long long id);
        HWND  makeRadioButton(HWND parent, long long id);
        HWND  makeEditArea(HWND parent, long long id);
        HWND  makeBoldLabel(HWND parent, long long id);
        HWND  makeLabel(HWND parent, long long id);
        HWND  makeRightAlignedLabel(HWND parent, long long id);
        HWND  makeHorizontalTrackbar(HWND parent, long long id);
        HWND  makeHorizontalSeparator(HWND parent, long long id);
        HWND  makeProgressBar(HWND parent, long long id);
        HWND  makeGroupBox(HWND parent, long long id);
        HWND  makeCheckBox(HWND parent, long long id);
    };

private:

    Win32Tools( );

    static  HFONT           sControlFaceFont;
    static  HFONT           sBoldLabelFont;
    static  Filesystem*     sFSInstance;
    static  WidgetFactory*  sWidgetFacInstance;

public:

    static  const unsigned short  kPushButtonHeight = 24;
    static  const unsigned short  kDialogPushButtonWidth = 84;
    static  const unsigned short  kHorizSeparatorWidth = 240;
    static  const unsigned short  kHorizSeparatorHeight = 2;
    static  const unsigned short  kEditAreaHeight = 20;
    static  const unsigned short  kLabelHeight = 13;
    static  const unsigned short  kRadioButtonHeight = 13;
    static  const unsigned short  kBoldLabelHeight = 13;
    static  const unsigned short  kTrackbarMinorAxis = 36;
    static  const unsigned short  kProgressBarHeight = 16;


    virtual ~Win32Tools( );
    
    static  std::string     getWindowTextString(HWND w);
    static  void            setWindowTextString(HWND w, const std::string& s);
    static  int             getWindowTextIntegral(HWND w);
    static  void            setWindowTextIntegral(HWND w, int val);
    static  bool            isWindowTextIntegral(HWND w);
    static  HFONT           getControlFaceFont( );
    static  void            applyControlFaceProperties(HWND w);
    static  HFONT           getBoldLabelFont( );
    static  void            applyBoldLabelProperties(HWND w);
    static  void            initializeGLClientState( );
    static  unsigned short  getWindowHeight(HWND w);
    static  unsigned short  getWindowWidth(HWND w);
    static  unsigned short  getClientAreaHeight(HWND w);
    static  unsigned short  getClientAreaWidth(HWND w);
    static  void            setWindowOrigin(HWND w, unsigned short x,
        unsigned short y);
    static  Vector2Di       getWindowOrigin(HWND w);
    static  void            setWindowWidth(HWND win, unsigned short wd);
    static  void            setWindowHeight(HWND win, unsigned short ht);
    static  void            destroyPrimitive(HWND& win);
    static  void            checkButton(HWND btn);
    static  void            uncheckButton(HWND btn);
    static  std::string     simplifyFilename(const std::string& filename);
    static  Filesystem&     filesystem( );
    static  WidgetFactory&  widgetFactory( );
    static  RGBColorNative  toNative(const RGBColor& c);
    static  RGBColor        fromNative(const RGBColorNative& c);
    static  PBITMAPINFO     toNative(const RGBAImage& img);
};

#endif
