//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// UserInteraction.h                                                        //
//                                                                          //
// Pacakges class defintions for InteractionToken, MouseInteractionToken,   //
// and InterstitialActionToken. Defines the InterstitialActionSender and    //
// InterstitialActionReceiver interfaces. Defines the UIComponentView and   //
// UIComponentController interfaces.                                        //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// ver 2.1.0 of Mon 12 May 2008 @ 3:27pm EDT                                //
//                                                                          //
//     added extended action cancellation support to interface              //
//     InterstitialActionSender -- new method cancelAction( ) may break     //
//     existing subclasses                                                  //
//                                                                          //
// ver 2.0.1 of Fri 3 May 2008 @ 7:54pm EDT                                 //
//                                                                          //
//     changed all references of class template Vertex2D to Vector2D; see   //
//     the AffineGeometry module's header for more info                     //
//                                                                          //
// ver 2.0.0 of Wed 26-Mar-2008 @ 5:56pm EDT                                //
//                                                                          //
//     Changed the UIComponentView and UIComponentController interfaces     //
//     such that their concrete subclasses must implement enable/disable    //
//     management support. Note that this will cause all of those           //
//     subclasses to fail to compile until they've been modified to         //
//     provide this support.                                                //
//                                                                          //
// older change history elided; check out an older CVS revision to get it   //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// Copyright (c) 2007-2008, Lucas Stephen Beeler. All Rights Reserved.      //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#ifndef USER_INTERACTION__HXX
#define USER_INTERACTION__HXX


#include <PTCITypes.h>
#include <string>
#include <set>


//-------------------------------------------------------------------------//
// CLASS  InteractionToken                                                 //
//-------------------------------------------------------------------------//
class InteractionToken {

protected:

    InteractionToken( );

public:

    virtual  ~InteractionToken( );
};
//-------------------------------------------------------------------------//





//-------------------------------------------------------------------------//
// CLASS  MouseInteractionToken                                            //
//-------------------------------------------------------------------------//
class MouseInteractionToken
    : public virtual InteractionToken {

public:

    enum  ButtonID  {kLeftButton, kRightButton, kMiddleButton };

private:

    Vector2Di  fLocation;
    ButtonID   fButtonID;

public:

    MouseInteractionToken(const Vector2Di&  loc, ButtonID btn);

    virtual  ~MouseInteractionToken( );

    virtual  const Vector2Di&  location( )  const;
    virtual  const ButtonID&  button( ) const;
};
//-------------------------------------------------------------------------//





//-------------------------------------------------------------------------//
// CLASS  InterstitialActionToken                                          //
//-------------------------------------------------------------------------//
class InterstitialActionToken
    : public virtual InteractionToken {

protected:

    int           fPercentProgress;
    std::string   fStatusMessage;


public:

    static  const std::string  kActionCanceledMessage;

    InterstitialActionToken(int pctprog);
    InterstitialActionToken(const std::string& stat);
    InterstitialActionToken(const std::string& stat, int pctprog);

    virtual  ~InterstitialActionToken( );

    virtual  int  percentProgress( )  const;
    virtual  const std::string&  statusMessage( ) const;
};
//-------------------------------------------------------------------------//





//-------------------------------------------------------------------------//
// INTERFACE  InterstitialActionSender                                     //
//-------------------------------------------------------------------------//
class InterstitialActionSender {

protected:

    InterstitialActionSender( ) { }

public:

    virtual  ~InterstitialActionSender( ) { }

    virtual  void  registerReceiver(InterstitialActionReceiver& recv) = 0;
    virtual  void  deregisterReceiver(InterstitialActionReceiver& recv) = 0;
    virtual  void  cancelAction(InterstitialActionReceiver& recv) = 0;
};
//-------------------------------------------------------------------------//





//-------------------------------------------------------------------------//
// INTERFACE  InterstitialActionReceiver                                   //
//-------------------------------------------------------------------------//
class InterstitialActionReceiver {

protected:

    InterstitialActionReceiver( ) { }

public:

    virtual  ~InterstitialActionReceiver( ) { }

    virtual  void  interstitialActionEvent(InterstitialActionSender& sender,
        const InterstitialActionToken& evt) = 0;
};
//-------------------------------------------------------------------------//




//-------------------------------------------------------------------------//
// TYPE  InterstitialActionReceiverSet                                     //
//-------------------------------------------------------------------------//
typedef std::set<InterstitialActionReceiver*> InterstitialActionReceiverSet;
//-------------------------------------------------------------------------//




//-------------------------------------------------------------------------//
// CLASS  UIComponentView                                                  //
//-------------------------------------------------------------------------//
class  UIComponentView {

protected:

    UIComponentView( ) { }

public:

    virtual ~UIComponentView( ) { }

    virtual  unsigned short  width( ) const = 0;
    virtual  void  setWidth(unsigned short w) = 0;
    virtual  unsigned short  height( ) const = 0;
    virtual  void  setHeight(unsigned short h) = 0;
    virtual  Vector2Di  position( ) const = 0;
    virtual  void  setPosition(const Vector2Di& p) = 0;
    virtual  unsigned short  clientWidth( ) const = 0;
    virtual  unsigned short  clientHeight( ) const = 0;
    virtual  HWND  peerHandle( ) = 0;
    virtual  void  invalidate( ) = 0;
    virtual  void  show( ) = 0;
    virtual  void  hide( ) = 0;
    virtual  bool  isVisible( ) const = 0;
    virtual  void  enable( ) = 0;
    virtual  void  disable( ) = 0;
    virtual  bool  isEnabled( ) const = 0;
};
//-------------------------------------------------------------------------//




//-------------------------------------------------------------------------//
// CLASS  UIComponentController                                            //
//-------------------------------------------------------------------------//
class  UIComponentController {

protected:

    UIComponentController( ) { }

public:

    virtual ~UIComponentController( ) { }

    virtual  bool  isInstalled( ) const = 0;
    virtual  void  viewEnabled(UIComponentView& sender) = 0;
    virtual  void  viewDisabled(UIComponentView& sender) = 0;
};
//-------------------------------------------------------------------------//

#endif
