//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// UserInteraction.cpp                                                      //
//                                                                          //
// Implements methods in the InteractionToken, MouseInteractionToken,       //
// and InterstitialActionToken classes, as well as the do-nothing c-tors &  //
// d-tors in the InterstitialActionSender and InterstitialActionReceiver    //
// interfaces.                                                              //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// ver 2.1.0 of Mon 12 May 2008 @ 3:27pm EDT                                //
//                                                                          //
//     added extended action cancellation support to interface              //
//     InterstitialActionSender -- new method cancelAction( ) may break     //
//     existing subclasses                                                  //
//                                                                          //
// ver 2.0.1 of Fri 3 May 2008 @ 7:54pm EDT                                 //
//                                                                          //
//     changed all references of class template Vertex2D to Vector2D; see   //
//     the AffineGeometry module's header for more info                     //
//                                                                          //
// ver 2.0.0 of Wed 26-Mar-2008 @ 5:56pm EDT                                //
//                                                                          //
//     Changed the UIComponentView and UIComponentController interfaces     //
//     such that their concrete subclasses must implement enable/disable    //
//     management support. Note that this will cause all of those           //
//     subclasses to fail to compile until they've been modified to         //
//     provide this support.                                                //
//                                                                          //
// older change history elided; check out an older CVS revision to get it   //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// Copyright (c) 2007-2008, Lucas Stephen Beeler. All Rights Reserved.      //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////


#include "UserInteraction.h"


//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// CLASS  InteractionToken                                                  //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
InteractionToken::InteractionToken( )
{
    ;
}




InteractionToken::~InteractionToken( )
{
    ;
}
//////////////////////////////////////////////////////////////////////////////
// END  InteractionToken                                                    //
//////////////////////////////////////////////////////////////////////////////





//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// CLASS  MouseInteractionToken                                             //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
MouseInteractionToken::MouseInteractionToken(const Vector2Di& loc,
    ButtonID btn) : fLocation(loc), fButtonID(btn)
{
}




MouseInteractionToken::~MouseInteractionToken( )
{
}




const Vector2Di&  MouseInteractionToken::location( )  const
{
    return fLocation;
}



const MouseInteractionToken::ButtonID&  MouseInteractionToken::button( ) const
{
    return fButtonID;
}
//////////////////////////////////////////////////////////////////////////////
// END  MouseInteractionToken                                               //
//////////////////////////////////////////////////////////////////////////////





//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// CLASS  InterstitialActionToken                                           //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
const std::string  InterstitialActionToken::kActionCanceledMessage =
    "IAT_Cancel";

InterstitialActionToken::InterstitialActionToken(int pctprog)
    : fPercentProgress(pctprog), fStatusMessage("")
{
}




InterstitialActionToken::InterstitialActionToken(const std::string& stat)
    : fPercentProgress(0), fStatusMessage(stat)
{
}




InterstitialActionToken::InterstitialActionToken(const std::string& stat,
    int pctprog)
        : fPercentProgress(pctprog), fStatusMessage(stat)
{
}





InterstitialActionToken::~InterstitialActionToken( )
{
}




int  InterstitialActionToken::percentProgress( )  const
{
    return fPercentProgress;
}




const std::string&  InterstitialActionToken::statusMessage( ) const
{
    return fStatusMessage;
}
//////////////////////////////////////////////////////////////////////////////
// END  InterstitialActionToken                                             //
//////////////////////////////////////////////////////////////////////////////
