//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// UIThingies.cpp                                                           //
//                                                                          //
// Implements methods in classes Thingy, CompositeThingyController and      //
// ThingyAdapter.                                                           //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//  <unversioned module>                                                    //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//  Copyright (c) 2008 Lucas Stephen Beeler. All Rights Reserved.           //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#include "UIThingies.h"

//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// CLASS  Thingy                                                            //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
int Thingy::sChildIDTicker = 1024;


int Thingy::nextChildID( )
{
    return sChildIDTicker++;
}
//////////////////////////////////////////////////////////////////////////////
// END  Thingy                                                              //
//////////////////////////////////////////////////////////////////////////////








//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// CLASS  CompositeThingyController                                         //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
class  NullCompositeThingyController :
    public virtual CompositeThingyController {

public:

    NullCompositeThingyController( ) { }

    virtual ~NullCompositeThingyController( ) { }

    void  layoutSubthingies(CompositeThingy& sender) { }
    void  enableSubthingies(CompositeThingy& sender) { }
    void  disableSubthingies(CompositeThingy& sender) { }
};

CompositeThingyController* CompositeThingyController::nullController( )
{
    return new NullCompositeThingyController( );
}
//////////////////////////////////////////////////////////////////////////////
// END  CompositeThingyController                                           //
//////////////////////////////////////////////////////////////////////////////








//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// CLASS  ThingyAdapter                                                     //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
std::map<HWND, ThingyAdapter*>  ThingyAdapter::sObjectMap;


LRESULT  ThingyAdapter::sUniversalProc(HWND target, UINT msgcode,
    WPARAM wparam, LPARAM lparam)
{
    if (sObjectMap.find(target) != sObjectMap.end( ))
        return getObject(target).fClient->processMessage(target,
            msgcode, wparam, lparam);
    else
        return DefWindowProc(target, msgcode, wparam, lparam);
}




ThingyAdapter&  ThingyAdapter::getObject(HWND primitive)
{
    if (sObjectMap.find(primitive) == sObjectMap.end( ))
        throw std::logic_error("ThingyAdapter: primitive isn't in object map");
    else
        return *sObjectMap[primitive];
}




void  ThingyAdapter::associateObject(HWND primitive, ThingyAdapter& obj)
{
    sObjectMap[primitive] = & obj;
}



void  ThingyAdapter::deleteAssociation(HWND primitive)
{
    if (sObjectMap.find(primitive) == sObjectMap.end( ))
        throw std::logic_error("ThingyAdapter: can't delete object map "
            "association: no assocation exists");

    sObjectMap.erase(primitive);
}



bool  ThingyAdapter::isPrimitiveAssociated(HWND primitive)
{
    if (sObjectMap.find(primitive) == sObjectMap.end( ))
        return false;
    else
        return true;
}




ThingyAdapter::ThingyAdapter(ThingyAdapterClient& client, HWND managed)
        : fClient(&client), fPrimitive(managed)
{
    associateObject(managed, *this);
}




ThingyAdapter::~ThingyAdapter( )
{
    if (fPrimitive != 0) {

        DestroyWindow(fPrimitive);
        deleteAssociation(fPrimitive);
        fPrimitive = 0;
    }
}




ThingyAdapter&  ThingyAdapter::parent( )
{
    if (!hasParent( ))
        throw std::logic_error("ThingyAdapter: can't get parent reference: "
            "window has no parent");
    else
        return getObject(GetParent(fPrimitive));
}




const ThingyAdapter&  ThingyAdapter::parent( ) const
{
    if (!hasParent( ))
        throw std::logic_error("ThingyAdapter: can't get parent reference: "
            "window has no parent");
    else
        return getObject(GetParent(fPrimitive));
}




bool  ThingyAdapter::hasParent( ) const
{
    if (GetParent(fPrimitive) != NULL)
        return true;
    else
        return false;
}




LRESULT  ThingyAdapter::propogateChildMessage(HWND target, UINT msgcode,
    WPARAM wparam, LPARAM lparam)
{
    switch (msgcode) {

        case WM_HSCROLL:
        case WM_COMMAND:
              /* only control msgs have non-null lparams */
            if (lparam) { 

                if (isPrimitiveAssociated((HWND) lparam))
                    return getObject(
                        (HWND) lparam).fClient->processParentMessage(
                        target, msgcode, wparam, lparam);
                else
                  return DefWindowProc(target, msgcode, wparam, lparam);
            }
            else {

                return DefWindowProc(target, msgcode, wparam, lparam);
            }
        break;

        default:
            return DefWindowProc(target, msgcode, wparam, lparam);
        break;
    }
}




HWND  ThingyAdapter::primitive( )
{
    return fPrimitive;
}



ThingyAdapterClient&  ThingyAdapter::client( )
{
    return *fClient;
}



const ThingyAdapterClient&  ThingyAdapter::client( ) const
{
    return *fClient;
}



void  ThingyAdapter::release( )
{
    deleteAssociation(fPrimitive);
    fPrimitive = 0;
}
//////////////////////////////////////////////////////////////////////////////
// END  ThingyAdapter                                                       //
//////////////////////////////////////////////////////////////////////////////
