//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// ThingyScrapbook.h                                                        //
//                                                                          //
// Packages interface definitions for classes SourceImageChooserThingy and  //
// SourceImageChooserController                                             //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// <unversioned module>                                                     //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// Copyright (c) 2008, Lucas Stephen Beeler. All Rights Reserved.           //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#ifndef THINGY_SCRAPBOOK__HXX
#define THINGY_SCRAPBOOK__HXX

#include <UIThingies.h>
#include <EssentialThingies.h>

class SourceImageChooserThingy :
    public virtual Thingy,
    public virtual CompositeThingyController,
    public virtual PushButtonController,
    public virtual InterstitialActionSender {

private:

    GroupBoxThingy                 fMasterControl;
    PushButtonThingy               fSetSourceButton;
    TextLabelThingy                fFileSourceLabel;
    InterstitialActionReceiverSet  fReceiverSet;
    int                            fWidthMinConst;
    int                            fWidthMaxConst;
    int                            fHeightMinConst;
    int                            fHeightMaxConst;
    float                          fAspectRatioConst;
    bool                           fIsPowerOf2ConstEnabled;
    RGBAImage*                     fSrcImgData;
    std::string                    fSrcFilename;

public:

    static  const unsigned short  kDefaultDimMinConstraint = 1;
    static  const unsigned short  kDefaultDimMaxConstraint = 2048;
    static  const float  kNoAspectRatioConstraint;

    SourceImageChooserThingy(CompositeThingy& composite);
    virtual ~SourceImageChooserThingy( );

    void  show( );
    void  hide( );
    bool  isVisible( );
    Vector2Di  origin( ) const;
    void  setOrigin(const Vector2Di& ogn);
    void  setOrigin(unsigned short x, unsigned short y);
    unsigned short  width( ) const;
    void  setWidth(unsigned short w);
    unsigned short  height( ) const;
    void  setHeight(unsigned short h);
    void  enable( );
    void  disable( );
    bool  isEnabled( ) const;
    void  layoutSubthingies(CompositeThingy& sender);
    void  enableSubthingies(CompositeThingy& sender);
    void  disableSubthingies(CompositeThingy& sender);
    void  thingyClicked(PushButtonThingy& sender);
    void  registerReceiver(InterstitialActionReceiver& recv);
    void  deregisterReceiver(InterstitialActionReceiver& recv);
    void  cancelAction(InterstitialActionReceiver& recv);
    virtual  const RGBAImage&  sourceImage( ) const;
    virtual  const std::string&  sourceFile( ) const;
    virtual  bool  isSourceImageSet( ) const;
};

#endif
