//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// StructuredIO.h                                                           //
//                                                                          //
// Packages the interface definition for class StructuredReader only.       //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// ver 2.0.0 of Fri 09-Jan-2009 @ 5:30am EST                                //
//                                                                          //
//     added support to install (define) macros that are automatically      //
//     expanded in quoted strings.                                          //
//                                                                          //
// ver 1.2.0 of Sun 26-Oct-2008 @ 7:21pm EDT                                //
//                                                                          //
//     added readQuotedString( ) to class StructuredReader                  //
//                                                                          //
// ver 1.1.0 of Thu 15-May-2008 @ 1:34pm EDT                                //
//                                                                          //
//     added readBoolean( ) and readFloat( ) to class Structured reader;    //
//     both methods were tested as part of MapPickerTester and are          //
//     considered stable                                                    //
//                                                                          //
// prior change history elided; check out an older CVS rev to get it        //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// Copyright (c) 2008-2009, Lucas Stephen Beeler. All Rights Reserved.      //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#ifndef STRUCTURED_IO__HXX
#define STURCTURED_IO__HXX

#include <Win32Support.h>
#include <PTCITypes.h>
#include <AffineGeometry.h>
#include <string>
#include <map>

class StructuredReader {

private:

    const std::string                    fTarget;
    int                                  fCursor;
    std::map<std::string, std::string>   fMacros;

    virtual  void         uSkipWhitespace( );
    virtual  std::string  uResolveMacro(const std::string& key) const;
    virtual  std::string  uReadMacro( );

public:

    StructuredReader(const std::string& target);
    virtual ~StructuredReader( );

    virtual  std::string  readFiletypeID( );
    virtual  std::string  readIdentifier( );
    virtual  void         readGroupOpen( );
    virtual  void         readGroupClose( );
    virtual  int          readInteger( );
    virtual  float        readFloat( );
    virtual  Vector2Di    readVector2Di( );
    virtual  void         readAssignmentOperator( );
    virtual  bool         readBoolean( );
    virtual  int          cursorPosition( ) const;
    virtual  int          targetLength( ) const;
    virtual  std::string  readQuotedString( );
    virtual  void         installMacro(const std::string&,
        const std::string&);
    virtual  void         removeMacro(const std::string&);
    virtual  bool         isMacroInstalled(const std::string&) const;
};

#endif
