//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// ModalDialog.h                                                            //
//                                                                          //
// Packages the definitions of class ModalDialogView and interface          //
// ModalDialogController                                                    //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// version 1.1.3 of Fri 3 May 2008 @ 7:40pm EDT                             //
//                                                                          //
//     changed all references of class template Vertex2D to Vector2D; see   //
//     the AffineGeometry module's header for more info                     //
//                                                                          //
// version 1.1.2 of Wednedsday 26 March 2008 @ 5:39pm EDT                   //
//                                                                          //
//     Added methods stubs for UIComponent-style enable/disable management  //
//     support to ModalDialog views and controllers. Note that these are    //
//     only stubs; they don't actually do anything, since it's unclear why  //
//     one would want to disable a *modal* dialog. Nevertheless, the        //
//     stubs need to be there so that ModalDialog views and controllers are //
//     interface-compliant with their UIComponent superclasses.             //
//                                                                          //
// older change history elided; check out an older CVS rev to get it        //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// Copyright (c) 2007-2008, Lucas Stephen Beeler. All Rights Reserved.      //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#include <PTCITypes.h>
#include <UserInteraction.h>
#include <string>
#include <map>

#ifndef MODAL_DIALOG_VIEW__HXX
#define MODAL_DIALOG_VIEW__HXX

//-------------------------------------------------------------------------//
// CLASS  ModalDialogView                                                  //
//-------------------------------------------------------------------------//
class ModalDialogView
    : public virtual UIComponentView {

private:

    static  const unsigned short  kDefaultMinHorizTrackSize = 64;
    static  const unsigned short  kDefaultMinVerticalTrackSize = 64;

    static  ModalDialogView*  sDialogAwaitingInit;
    static  std::map<HWND, ModalDialogView*>  sObjectMap;

    static  INT_PTR  CALLBACK  sDialogProc(HWND target, UINT msgcode,
        WPARAM wparam, LPARAM lparam);

    bool                    fIsInteractionStopping;
    bool                    fIsInteractionCacheOnly;
    bool                    fIsAutoPosEnabled;
    std::string             fTitleCache;
    unsigned short          fHeightCache;
    unsigned short          fWidthCache;
    Vector2Di               fPosCache;
    Vector2Di               fRealPos;
    ModalDialogController*  fController;
    int                     fTemplateResID;
    unsigned short          fMinVerticalTrackSize;
    unsigned short          fMinHorizTrackSize;


    void  uSyncState( );
    void  uCachePeerState( );
    void  uAutoPosition( );

protected:

    HWND  fDialogPrimitive;
    HWND  fParentWindow;

    virtual  INT_PTR  uProcessDialogMessage(HWND target, UINT msgcode,
        WPARAM wparam, LPARAM lparam);

public:

    ModalDialogView(HWND parent, int resid);
    virtual ~ModalDialogView( );

    static  const Vector2Di       kDefaultPosition;
    static  const std::string     kDefaultTitle;
    static  const bool            kDefaultAutoPositionState;
    static  const unsigned short  kChildID0 = 2048;

    virtual  std::string  title( ) const;
    virtual  void  setTitle(const std::string& s);
    virtual  unsigned short  height( ) const;
    virtual  void  setHeight(unsigned short h);
    virtual  unsigned short  width( ) const;
    virtual  void  setWidth(unsigned short w);
    virtual  Vector2Di  position( ) const;
    virtual  void  enableAutoPosition( );
    virtual  void  disableAutoPosition( );
    virtual  bool  isAutoPositionEnabled( ) const;
    virtual  void  setPosition(const Vector2Di& p);
    virtual  HWND  peerHandle( );
    virtual  void  invalidate( );
    virtual  ModalDialogController&  controller( );
    virtual  ModalDialogController&  installController(
        ModalDialogController& c);
    virtual  void  startInteraction( );
    virtual  void  finishInteraction( );
    virtual  bool  isInteractionRunning( ) const;
    virtual  void  show( );
    virtual  void  hide( );
    virtual  bool  isVisible( ) const;
    virtual  void  enable( );
    virtual  void  disable( );
    virtual  bool  isEnabled( ) const;
    virtual  HWND  itemPeer(int resid);
    virtual  unsigned short  clientWidth( ) const;
    virtual  unsigned short  clientHeight( ) const;
    virtual  unsigned short  minHorizTrackSize( ) const;
    virtual  void  setMinHorizTrackSize(unsigned short mhs);
    virtual  unsigned short  minVerticalTrackSize( ) const;
    virtual  void  setMinVerticalTrackSize(unsigned short mvs);
};
//-------------------------------------------------------------------------//




//-------------------------------------------------------------------------//
// INTERFACE  ModalDialogController                                        //
//-------------------------------------------------------------------------//
class ModalDialogController 
    : public virtual UIComponentController {

protected:

    ModalDialogController( );

public:

    static  ModalDialogController*  nullController( );

    virtual  ~ModalDialogController( );

    virtual  void  installed(ModalDialogView& sender) = 0;
    virtual  void  deinstalled(ModalDialogView& sender) = 0;
    virtual  bool  isInstalled( ) const = 0;
    virtual  void  layout(ModalDialogView& sender) = 0;
    virtual  void  image(ModalDialogView& sender) = 0;
    virtual  void  commandPropagated(ModalDialogView& sender,
        HWND commandSource, unsigned short commandID) = 0;
    virtual  void  interactionStarted(ModalDialogView& sender) = 0;
    virtual  void  interactionFinished(ModalDialogView& sender) = 0;
    virtual  void  dialogClosed(ModalDialogView& sender) = 0;
    virtual  void  viewEnabled(UIComponentView& sender) = 0;
    virtual  void  viewDisabled(UIComponentView& sender) = 0;
};
//-------------------------------------------------------------------------//

#endif
