//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// MapPicker.h                                                              //
//                                                                          //
// Packages the interface definition for class MapPicker only               //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// <unversioned module>                                                     //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// Copyright (c) 2008, Lucas Stephen Beeler. All Rights Reserved.           //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#ifndef MAP_PICKER__HXX
#define MAP_PICKER__HXX

#include <PTCITypes.h>
#include <ModalDialog.h>
#include <vector>
#include <string>

class MapPicker :
    public virtual ModalDialogController {

private:

    struct MapHeaderRecord {

        int    basedim;
        int    numlevs;
        int    entries;
        bool   isboosted;
        float  boostfrac;
    };

    std::string               fBrushPath;
    std::vector<std::string>  fMatchingMaps;
    ModalDialogView           fManagedView;
    HWND                      fOverlayPeer;
    HWND                      fMapListBox;
    HWND                      fMapPropertiesGroup;
    HWND                      fBaseDimLabel;
    HWND                      fBaseDimReadout;
    HWND                      fEncodedLevsLabel;
    HWND                      fEncodedLevsReadout;
    HWND                      fEntriesLabel;
    HWND                      fEntriesReadout;
    HWND                      fVarBoostLabel;
    HWND                      fVarBoostReadout;
    HWND                      fBoostFracLabel;
    HWND                      fBoostFracReadout;
    HWND                      fCancelButton;
    HWND                      fSelectButton;
    HWND                      fHorizSeparator;
    bool                      fDidUserCancel;
    std::string               fUserMapPath;

    void  uAssociateResDefines( );
    void  uStylizeResDefines( );
    void  uPopulateMapListBox( );
    void  uReadMapHeader(int mapnum, MapHeaderRecord& output);
    void  uLoadPropsFields(int mapnum);

public:

    static  const std::string  kNoMapsFoundMessage;

    MapPicker(HWND overlaypeer);
    virtual  ~MapPicker( );

    virtual  std::string  runInteraction( );
    virtual  void  setBrushPath(const std::string& brushpath);
    virtual  bool  isBrushPathSet( ) const;

    void  installed(ModalDialogView& sender);
    void  deinstalled(ModalDialogView& sender);
    bool  isInstalled( ) const;
    void  layout(ModalDialogView& sender);
    void  image(ModalDialogView& sender);
    void  commandPropagated(ModalDialogView& sender,
        HWND commandSource, unsigned short commandID);
    void  interactionStarted(ModalDialogView& sender);
    void  interactionFinished(ModalDialogView& sender);
    void  dialogClosed(ModalDialogView& sender);
    void  viewEnabled(UIComponentView& sender);
    void  viewDisabled(UIComponentView& sender);

};

#endif
