//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// ImageInspector.h                                                         //
//                                                                          //
// Packages the ImageInspector class definition.                            //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// ver. 1.1.2 of Tue 20 May 2008 @ 2:32pm EDT                               //
//                                                                          //
//    fixed hidden widget problem by adding ShowWindow( ) calls following   //
//    calls to widget factory creation routines                             //
//                                                                          //
// ver. 1.1.1 of Fri 3 May 2008 @ 11:33pm EDT                               //
//                                                                          //
//     changed all references of class template Vertex2D to Vector2D; see   //
//     the AffineGeometry module's header for more info                     //
//                                                                          //
// previous change history elided; check out an older CVS rev to get it     //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// Copyright (c) 2008, Lucas Stephen Beeler. All Rights Reserved.           //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#ifndef LDX_IMAGE_INSPECTOR__HXX
#define LDX_IMAGE_INSPECTOR__HXX

#include  <ModalDialog.h>
#include  <ImageRepresentation.h>

class ImageInspector {

private:

    class  DialogController;
    friend class  DialogController;

    class  ImageStatsPaneController;
    friend class  ImageStatsPaneController;

    DialogController*  fInspectorDlgCtlr;
    ModalDialogView*   fInspectorDlgView;
    const RGBAImage*   fTargetImage;

    static const char*  sFormatNames[ ];

public:

    ImageInspector(HWND overlayPeer);
    ImageInspector(HWND overlayPeer, const RGBAImage& target);
    virtual ~ImageInspector( );

    virtual  void  runInspectionInteraction( );
    void  setTargetImage(const RGBAImage& img);
};

#endif
