//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// GLCanvasWindow.h                                                         //
//                                                                          //
// Pacakges class definitons of classes GLCanvasWindowView and              //
// GLCanvasWindowController                                                 //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// ver 2.2.0 of Thu 22 May 2008 @ 12:04pm EDT                               //
//                                                                          //
//    added method makeCommandFocus( )                                      //
//                                                                          //
// ver 2.1.1 of Fri 3 May 2008 @ 7:35pm EDT                                 //
//                                                                          //
//    changed all references of class template Vertex2D to Vector2D; see    //
//    the AffineGeometry module's header for more info                      //
//                                                                          //
// ver 2.1.0 of Wed 26-Mar-2008 @ 5:20pm EDT                                //
//                                                                          //
//    Added methods viewEnabled( ) and viewDisabled( ) to class             //
//    GLCanvasWindowController so as to make its interface compliant with   //
//    that of its superclass UIComponentController. Added overrides of      //
//    enable( ) and disable( ) to class GLCanvasWindowView so as to make    //
//    GLCanvasWindowViews properly notify their controllers when they've    //
//    been enabled or disabled.                                             //
//                                                                          //
// older change history elided; check out an older CVS rev to get it        //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// Copyright (c) 2007-2008, Lucas Stephen Beeler. All Rights Reserved.      //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#ifndef GL_CANVAS_WINDOW__HXX
#define GL_CANVAS_WINDOW__HXX

#include <CanvasWindow.h>
#include <GPUInterface.h>
#include <UserInteraction.h>

//-------------------------------------------------------------------------//
// CLASS  GLCanvasWindowView                                               //
//-------------------------------------------------------------------------//
class GLCanvasWindowView
    : public virtual CanvasWindowView {

private:

    GLCanvasWindowController*  fController;
    HGLRC                      fRenderingContext;
    HDC                        fRenderingContextDC;
    GPUInterface*              fDeviceInterface;
    bool                       fIsTrackInProgress;

protected:

    /* overrides of existing base class methods */
    LRESULT  uProcessWindowMessage(HWND targetWindow, UINT messageCode,
        WPARAM wParam, LPARAM lParam);
    LRESULT  uProcessCanvasMessage(HWND targetWindow, UINT messageCode,
        WPARAM wParam, LPARAM lParam);

public:

    GLCanvasWindowView( );
    virtual ~GLCanvasWindowView( );

    /* overrides of existing base class methods */
    void  setLeftMargin(unsigned short lm);
    void  setRightMargin(unsigned short rm);
    void  setTopMargin(unsigned short tm);
    void  setBottomMargin(unsigned short bm);
    void  setWidth(unsigned short w);
    void  setHeight(unsigned short h);
    void  enable( );
    void  disable( );

    /* new methods declared for this class */
    virtual  GLCanvasWindowController&  controller( );
    virtual  GLCanvasWindowController&  installController(
        GLCanvasWindowController& c);
    virtual  GPUInterface&  gpuInterface( );
    virtual  void  reimage( );
    virtual  void  makeCommandFocus( );
};
//-------------------------------------------------------------------------//




//-------------------------------------------------------------------------//
// CLASS  GLCanvasWindowController                                         //
//-------------------------------------------------------------------------//
class GLCanvasWindowController
    : public virtual UIComponentController {

protected:

    GLCanvasWindowController( );

public:

    static  GLCanvasWindowController*  nullController( );

    virtual  ~GLCanvasWindowController( );

    virtual  void  installed(GLCanvasWindowView& sender) = 0;
    virtual  void  deinstalled(GLCanvasWindowView& sender) = 0;
    virtual  void  layout(GLCanvasWindowView& sender) = 0;
    virtual  void  image(GLCanvasWindowView& sender) = 0;
    virtual  void  viewClosed(GLCanvasWindowView& sender) = 0;
    virtual  void  viewEnabled(UIComponentView& sender) = 0;
    virtual  void  viewDisabled(UIComponentView& sender) = 0;
    virtual  void  commandPropagated(GLCanvasWindowView& sender,
        HWND commandSource, unsigned short commandID) = 0;
    virtual  void  canvasMousePressed(GLCanvasWindowView& sender,
        const MouseInteractionToken& eventToken) = 0;
    virtual  void  canvasMouseReleased(GLCanvasWindowView& sender,
        const MouseInteractionToken& eventToken) = 0;
    virtual  void  canvasMouseTracked(GLCanvasWindowView& sender,
        const MouseInteractionToken& eventToken) = 0;
};
//-------------------------------------------------------------------------//

#endif
