//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// GLCanvasWindow.cpp                                                       //
//                                                                          //
// Implements methods in class GLCanvasWindowView; also defines class       //
// NullGLCanvasWindowController and implements its methods                  //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// ver 2.2.0 of Thu 22 May 2008 @ 12:04pm EDT                               //
//                                                                          //
//    added method makeCommandFocus( )                                      //
//                                                                          //
// ver 2.1.1 of Fri 3 May 2008 @ 7:35pm EDT                                 //
//                                                                          //
//    changed all references of class template Vertex2D to Vector2D; see    //
//    the AffineGeometry module's header for more info                      //
//                                                                          //
// ver 2.1.0 of Wed 26-Mar-2008 @ 5:20pm EDT                                //
//                                                                          //
//    Added methods viewEnabled( ) and viewDisabled( ) to class             //
//    GLCanvasWindowController so as to make its interface compliant with   //
//    that of its superclass UIComponentController. Added overrides of      //
//    enable( ) and disable( ) to class GLCanvasWindowView so as to make    //
//    GLCanvasWindowViews properly notify their controllers when they've    //
//    been enabled or disabled.                                             //
//                                                                          //
// older change history elided; check out an older CVS rev to get it        //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// Copyright (c) 2007-2008, Lucas Stephen Beeler. All Rights Reserved.      //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#include "GLCanvasWindow.h"
#include <cstdio>
#include <cstring>
#include <cstdlib>

//
// NullGLCanvasWindowController
//

class NullGLCanvasWindowController
    : public virtual GLCanvasWindowController {

private:

    bool  fIsInstalled;

public:

    NullGLCanvasWindowController( );
    virtual  ~NullGLCanvasWindowController( );

    void  installed(GLCanvasWindowView& sender);
    void  deinstalled(GLCanvasWindowView& sender);
    void  layout(GLCanvasWindowView& sender);
    void  image(GLCanvasWindowView& sender);
    void  viewClosed(GLCanvasWindowView& sender);
    void  viewEnabled(UIComponentView& sender);
    void  viewDisabled(UIComponentView& sender);
    void  commandPropagated(GLCanvasWindowView& sender, HWND commandSource,
        unsigned short commandID);
    bool  isInstalled( ) const;
    void  canvasMousePressed(GLCanvasWindowView& sender,
        const MouseInteractionToken& eventToken);
    void  canvasMouseTracked(GLCanvasWindowView& sender,
        const MouseInteractionToken& eventToken);
    void  canvasMouseReleased(GLCanvasWindowView& sender,
        const MouseInteractionToken& eventToken);
};




NullGLCanvasWindowController::NullGLCanvasWindowController( )
    : fIsInstalled(false)
{
    ;
}




NullGLCanvasWindowController::~NullGLCanvasWindowController( )
{
    ;
}




void  NullGLCanvasWindowController::layout(GLCanvasWindowView& sender)
{
    ;
}




void  NullGLCanvasWindowController::image(GLCanvasWindowView& sender)
{
    ;
}




void  NullGLCanvasWindowController::viewClosed(GLCanvasWindowView& sender)
{
    ;
}




void  NullGLCanvasWindowController::installed(GLCanvasWindowView& sender)
{
    fIsInstalled = true;
}




void  NullGLCanvasWindowController::deinstalled(GLCanvasWindowView& sender)
{
    fIsInstalled = false;
}




void  NullGLCanvasWindowController::commandPropagated(
    GLCanvasWindowView& sender, HWND commandSource, unsigned short commandID)

{
    ;
}



bool  NullGLCanvasWindowController::isInstalled( ) const
{
    return fIsInstalled;
}




void  NullGLCanvasWindowController::canvasMousePressed(
    GLCanvasWindowView& sender, const MouseInteractionToken& eventToken)
{
}




void  NullGLCanvasWindowController::canvasMouseTracked(
    GLCanvasWindowView& sender, const MouseInteractionToken& eventToken)
{
}




void  NullGLCanvasWindowController::canvasMouseReleased(
    GLCanvasWindowView& sender, const MouseInteractionToken& eventToken)
{
}




void  NullGLCanvasWindowController::viewEnabled(UIComponentView& sender)
{
}




void  NullGLCanvasWindowController::viewDisabled(UIComponentView& sender)
{
}









//
// GLCanvasWindowView
//

GLCanvasWindowView::GLCanvasWindowView( )
    : CanvasWindowView("GLCanvasWindow"), fRenderingContext(0),
      fController(new NullGLCanvasWindowController( )),
      fDeviceInterface(0), fIsTrackInProgress(false)
{
    PIXELFORMATDESCRIPTOR canvasPFD;
    
    canvasPFD.nSize = sizeof(PIXELFORMATDESCRIPTOR);
    canvasPFD.nVersion = 1;
    canvasPFD.dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL |
        PFD_DOUBLEBUFFER;
    canvasPFD.iPixelType = PFD_TYPE_RGBA;
    canvasPFD.cColorBits = 24;
    canvasPFD.cRedBits = 0;
    canvasPFD.cRedShift = 0;
    canvasPFD.cGreenBits = 0;
    canvasPFD.cGreenShift = 0;
    canvasPFD.cBlueBits= 0;
    canvasPFD.cBlueShift = 0;
    canvasPFD.cAlphaBits = 0;
    canvasPFD.cAlphaShift = 0;
    canvasPFD.cAccumBits = 0;
    canvasPFD.cAccumRedBits = 0;
    canvasPFD.cAccumGreenBits = 0;
    canvasPFD.cAccumBlueBits = 0;
    canvasPFD.cAccumAlphaBits = 0;
    canvasPFD.cDepthBits = 32;
    canvasPFD.cStencilBits = 0;
    canvasPFD.cAuxBuffers = 4;
    canvasPFD.iLayerType = PFD_MAIN_PLANE;
    canvasPFD.bReserved = 0;
    canvasPFD.dwLayerMask = 0;
    canvasPFD.dwVisibleMask = 0;
    canvasPFD.dwDamageMask = 0;

    fRenderingContextDC = GetDC(fCanvasWindowPrimitive);

    int  canvasPixelFormatID = ChoosePixelFormat(fRenderingContextDC,
        &canvasPFD);
    SetPixelFormat(fRenderingContextDC, canvasPixelFormatID, &canvasPFD);
    fRenderingContext = wglCreateContext(fRenderingContextDC);
    if (!fRenderingContext)
        throw std::runtime_error("GLCanvasWindowView: GLCanvasWindowView( ) "
            "couldn't create an OpenGL rendering context.");
    wglMakeCurrent(fRenderingContextDC, fRenderingContext);
    Win32Tools::initializeGLClientState( );

    fDeviceInterface = new GPUInterface(fRenderingContextDC,
        fRenderingContext);
}




GLCanvasWindowView::~GLCanvasWindowView( )
{
    fController->deinstalled(*this);

    delete fDeviceInterface;

    ReleaseDC(fCanvasWindowPrimitive, fRenderingContextDC);

    if (typeid(*fController) == typeid(NullGLCanvasWindowController))
        delete fController;
}




GLCanvasWindowController&  GLCanvasWindowView::controller( )
{
    return *fController;
}




GLCanvasWindowController&  GLCanvasWindowView::installController(
    GLCanvasWindowController& c)
{
    wglMakeCurrent(fRenderingContextDC, fRenderingContext);

    GLCanvasWindowController*  oldController = fController;

    oldController->deinstalled(*this);

    fController = &c;

    fController->installed(*this);

    return *oldController;
}




void  GLCanvasWindowView::setLeftMargin(unsigned short lm)
{
    wglMakeCurrent(fRenderingContextDC, fRenderingContext);

    CanvasWindowView::setLeftMargin(lm);

    fController->layout(*this);
}




void  GLCanvasWindowView::setRightMargin(unsigned short rm)
{
    wglMakeCurrent(fRenderingContextDC, fRenderingContext);

    CanvasWindowView::setRightMargin(rm);

    fController->layout(*this);
}




void  GLCanvasWindowView::setTopMargin(unsigned short tm)
{
    wglMakeCurrent(fRenderingContextDC, fRenderingContext);

    CanvasWindowView::setTopMargin(tm);

    fController->layout(*this);
}




void  GLCanvasWindowView::setBottomMargin(unsigned short bm)
{
    wglMakeCurrent(fRenderingContextDC, fRenderingContext);

    CanvasWindowView::setBottomMargin(bm);

    fController->layout(*this);
}




void  GLCanvasWindowView::setWidth(unsigned short w)
{
    wglMakeCurrent(fRenderingContextDC, fRenderingContext);

    CanvasWindowView::setWidth(w);

    fController->layout(*this);
}




void  GLCanvasWindowView::setHeight(unsigned short h)
{
    wglMakeCurrent(fRenderingContextDC, fRenderingContext);

    CanvasWindowView::setHeight(h);

    fController->layout(*this);
}




void  GLCanvasWindowView::enable( )
{
    CanvasWindowView::enable( );

    fController->viewEnabled(*this);
}




void  GLCanvasWindowView::disable( )
{
    CanvasWindowView::disable( );

    fController->viewDisabled(*this);
}




LRESULT  GLCanvasWindowView::uProcessWindowMessage(HWND targetWindow,
    UINT messageCode, WPARAM wParam, LPARAM lParam)
{
    LRESULT  result = 0;

    switch (messageCode) {

        case WM_SIZE:
            wglMakeCurrent(fRenderingContextDC, fRenderingContext);

            result = CanvasWindowView::uProcessWindowMessage(targetWindow,
                messageCode, wParam, lParam);
            fController->layout(*this);

            return result;
        break;

        case WM_CLOSE:
            wglMakeCurrent(fRenderingContextDC, fRenderingContext);

            result = CanvasWindowView::uProcessWindowMessage(targetWindow,
                messageCode, wParam, lParam);
            fController->viewClosed(*this);

            return result;
        break;

        case WM_COMMAND:
            wglMakeCurrent(fRenderingContextDC, fRenderingContext);

            result = CanvasWindowView::uProcessWindowMessage(targetWindow,
                messageCode, wParam, lParam);
            fController->commandPropagated(*this, (HWND)(lParam),
                static_cast<unsigned short>(HIWORD(wParam)));

            return result;
        break;

        default:
            return CanvasWindowView::uProcessWindowMessage(targetWindow,
                messageCode, wParam, lParam);
        break;
    }
}




LRESULT  GLCanvasWindowView::uProcessCanvasMessage(HWND targetWindow,
    UINT messageCode, WPARAM wParam, LPARAM lParam)
{
    HDC           canvasDC;
    PAINTSTRUCT   eventPS;
    int           canvas_h = 0;
    short         mouse_x = 0;
    short         mouse_y = 0;


    switch (messageCode) {

        case WM_PAINT:
            canvasDC = BeginPaint(targetWindow, &eventPS);

            wglMakeCurrent(fRenderingContextDC, fRenderingContext);
            fController->image(*this);
            SwapBuffers(fRenderingContextDC);
            EndPaint(targetWindow, &eventPS);

            return 0;
        break;

        case WM_LBUTTONDOWN:
            wglMakeCurrent(fRenderingContextDC, fRenderingContext);

            canvas_h = this->canvasClientHeight( );
            mouse_x = LOWORD(lParam);
            mouse_y = HIWORD(lParam);

            fController->canvasMousePressed(*this,
                MouseInteractionToken(Vector2Di(mouse_x, canvas_h -
                mouse_y), MouseInteractionToken::kLeftButton));;

            SetCapture(fCanvasWindowPrimitive);
            fIsTrackInProgress = true;

            return 0;
        break;

        case WM_LBUTTONUP:
            wglMakeCurrent(fRenderingContextDC, fRenderingContext);

            canvas_h = this->canvasClientHeight( );
            mouse_x = LOWORD(lParam);
            mouse_y = HIWORD(lParam);

            fController->canvasMouseReleased(*this,
                MouseInteractionToken(Vector2Di(mouse_x, canvas_h -
                mouse_y), MouseInteractionToken::kLeftButton));

            ReleaseCapture( );
            fIsTrackInProgress = false;

            return 0;
        break;


        case WM_RBUTTONDOWN:
            wglMakeCurrent(fRenderingContextDC, fRenderingContext);

            canvas_h = this->canvasClientHeight( );
            mouse_x = LOWORD(lParam);
            mouse_y = HIWORD(lParam);

            fController->canvasMousePressed(*this,
                MouseInteractionToken(Vector2Di(mouse_x, canvas_h -
                mouse_y), MouseInteractionToken::kRightButton));

            return 0;
        break;

        case WM_RBUTTONUP:
            wglMakeCurrent(fRenderingContextDC, fRenderingContext);

            canvas_h = this->canvasClientHeight( );
            mouse_x = LOWORD(lParam);
            mouse_y = HIWORD(lParam);

            fController->canvasMouseReleased(*this,
                MouseInteractionToken(Vector2Di(mouse_x, canvas_h -
                mouse_y), MouseInteractionToken::kRightButton));

            return 0;
        break;

        case WM_MOUSEMOVE:
            wglMakeCurrent(fRenderingContextDC, fRenderingContext);

            canvas_h = this->canvasClientHeight( );
            mouse_x = LOWORD(lParam);
            mouse_y = HIWORD(lParam);

            if (fIsTrackInProgress)
                fController->canvasMouseTracked(*this,
                    MouseInteractionToken(Vector2Di(mouse_x, canvas_h -
                    mouse_y), MouseInteractionToken::kLeftButton));

            return 0;
        break;

        default:
            return CanvasWindowView::uProcessCanvasMessage(targetWindow,
                messageCode, wParam, lParam);
        break;
    }
}



GPUInterface&  GLCanvasWindowView::gpuInterface( )
{
    return *fDeviceInterface;
}




void  GLCanvasWindowView::reimage( )
{
    wglMakeCurrent(fRenderingContextDC, fRenderingContext);
    fController->image(*this);
    SwapBuffers(fRenderingContextDC);
}




void  GLCanvasWindowView::makeCommandFocus( )
{
    wglMakeCurrent(fRenderingContextDC, fRenderingContext);
}











//
// GLCanvasWindowController
//

GLCanvasWindowController::GLCanvasWindowController( )
{
}




GLCanvasWindowController::~GLCanvasWindowController( )
{
}




GLCanvasWindowController*  GLCanvasWindowController::nullController( )
{
    return new NullGLCanvasWindowController( );
}
