//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// FileChooser.h                                                            //
//                                                                          //
// Defines the FileChooser interface.                                       //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// ver. 1.1.0 of Sat 18 Oct 2008 @ 9:10pm EDT                               //
//                                                                          //
//     Added another overload of method runFileChoiceInteraction( ) that    //
//     takes a Thingy& reference argument specifying the Thingy that owns   //
//     the file chooser popup window.                                       //
//                                                                          //
// ver. 1.0.0 of Wed 16-May-2007 @ 9:50pm EDT                               //
//                                                                          //
//     Adapted directly from Studio580 version.                             //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// Copyright (c) 2007-2008, Lucas Stephen Beeler. All Rights Reserved.      //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#ifndef FILE_CHOOSER__HXX
#define FILE_CHOOSER__HXX

#include <Win32Support.h>
#include <PTCITypes.h>
#include <string>
#include <map>
#include <vector>
#include <cstdarg>

class FileChooser {

protected:

    typedef std::map<std::string, std::vector<std::string>> TFiletypeTable;

    static  const char*  kGenericFiletypeMask;

    OPENFILENAME    fFeaturesDescriptor;
    TFiletypeTable  fFiletypeTable;
    char            fDialogTitle[256];
    char            fNameBuffer[_MAX_PATH];
    char            fTypeMaskBuffer[_MAX_PATH];

    FileChooser( );

    void  uPopulateTypeMaskBuffer( );

public:

    static  const std::string  kDone;

    virtual ~FileChooser( );

    virtual  std::string  title( ) const;
    virtual  void  setTitle(const std::string& t);
    virtual  std::string  runFileChoiceInteraction( ) = 0;
    virtual  std::string  runFileChoiceInteraction(
        CanvasWindowView& win) = 0;
    virtual  std::string  runFileChoiceInteraction(HWND win) = 0;
    virtual  std::string  runFileChoiceInteraction(const Thingy&) = 0;

    virtual  void  addFiletypeMask(const std::string& uniqueDesc,
        const std::string&);
    virtual  void  removeFiletypeMask(const std::string&);
};

#endif