//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// ControllerScrapbook.h                                                    //
//                                                                          //
// Defines classes SourceImageController and PyramidLevelController         //
// as well as interfaces SourceImageControllerParent and                    //
// PyramidLevelControllerParent                                             //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// ver. 1.4.1 of Mon 16 June 2008 @ 11:50pm EDT                             //
//                                                                          //
//    Fixed:  fixed hidden widget problems in class PyramidLevelController  //
//                                                                          //
// ver. 1.4.0 of Tue 20 May 2008 @ 2:25pm EDT                               //
//                                                                          //
//    New:    added new source image file path access functionality.        //
//    Fixed:  fixed hidden widget problem by adding ShowWindow( ) calls     //
//            immediately following calls to widget factory creation        //
//            routines; added a do-nothing cancelAction( ) method to        //
//            comply with changes in the InterstitialActionSender interface //
//                                                                          //
// ver.  1.3.2 of Wednesday 27 March 2008 @ 7:44pm EDT                      //
//                                                                          //
//    Added methods viewEnabled( ) and viewDisabled( ) to class             //
//    PyramidLevelController to make it compliant with its superclass       //
//    WorkPaneController.                                                   //
//                                                                          //
// older versions:                                                          //
//                                                                          //
//     modification log elided for versions several generations old;        //
//     checkout older revisions from CVS repository for complete changelog  //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// Copyright (c) 2007-2008, Lucas Stephen Beeler. All Rights Reserved.      //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#include <PTCITypes.h>
#include <WorkPane.h>
#include <OpenFileChooser.h>
#include <ImageInspector.h>
#include <climits>

class  SourceImageController;
class  SourceImageControllerParent;
class  PyramidLevelController;
class  PyramidLevelControllerParent;
class  TrackerThingyController;
class  TrackerThingyControllerParent;


//-------------------------------------------------------------------------//
// CLASS  SourceImageController                                            //
//-------------------------------------------------------------------------//
class  SourceImageController
    : public virtual WorkPaneController,
      public virtual InterstitialActionSender {

private:

    static  const unsigned short  kDefaultPaneWidth = 322;
    static  const unsigned short  kDefaultPaneHeight = 27;
    static  const unsigned short  kTitleLabelWidth = 90;
    static  const unsigned short  kFilenameLabelWidth = 150;
    static  const unsigned short  kDefaultButtonWidth = 60;
    static  const unsigned short  kSpacePixels = 6;
    static  const unsigned short  kDefaultButtonSpacing = 8;
    static  const unsigned short  kInspectButtonChildID =
        WorkPaneView::kChildID0 + 32;

    SourceImageControllerParent*           fParent;
    HWND                                   fTitleLabel;
    HWND                                   fFilenameLabel;
    HWND                                   fSetButton;
    HWND                                   fInspectButton;
    FileChooser*                           fSrcImgFileChooser;
    RGBAImage*                             fSrcImgData;
    WorkPaneView*                          fManagedView;
    int                                    fReadoutLeftEdge;
    int                                    fWidthMinConst;
    int                                    fWidthMaxConst;
    int                                    fHeightMinConst;
    int                                    fHeightMaxConst;
    float                                  fAspectRatioConst;
    bool                                   fIsInspectionEnabled;
    ImageInspector*                        fImageInspector;
    int                                    fButtonWidth;
    int                                    fButtonSpacing;
    bool                                   fIsPowerOf2ConstEnabled;
    std::set<InterstitialActionReceiver*>  fReceiverSet;
    std::string                            fSrcImgPath;

    void  uRunImageSetInteraction( );
    void  uDispatchIAEvents( );

public:

    static  const int    kImageMinWidth = 1;
    static  const int    kImageMinHeight = 1;
    static  const int    kImageMaxWidth = INT_MAX;
    static  const int    kImageMaxHeight = INT_MAX;
    static  const float  kNoAspectRatioConstraint;

    SourceImageController(SourceImageControllerParent& parent);
    virtual  ~SourceImageController( );

    void  installed(WorkPaneView& sender);
    void  deinstalled(WorkPaneView& sender);
    void  layout(WorkPaneView& sender);
    void  commandPropagated(WorkPaneView& sender,
        HWND commandSource, unsigned short commandID);
    virtual  RGBAImage&  sourceImageData( );
    virtual  const std::string&  sourceImagePath( ) const;
    bool  isSourceImageLoaded( ) const;
    bool  isInstalled( ) const;
    void  viewEnabled(UIComponentView& sender);
    void  viewDisabled(UIComponentView& sender);
    void  setReadoutLeftEdge(int le);
    int   readoutLeftEdge( ) const;
    void  setWidthConstraint(int minwd, int maxwd);
    void  setHeightConstraint(int minht, int maxht);
    void  setAspectRatioConstraint(float ar);
    void  enableInspection( );
    void  disableInspection( );
    bool  isInspectionEnabled( );
    int   buttonSpacing( ) const;
    void  setButtonSpacing(int spacing);
    int   buttonWidth( ) const;
    void  setButtonWidth(int bw);
    void  enablePowerOf2Constraint( );
    void  disablePowerOf2Constraint( );
    bool  isPowerOf2ConstraintEnabled( );
    void  registerReceiver(InterstitialActionReceiver& recv);
    void  deregisterReceiver(InterstitialActionReceiver& recv);
    void  cancelAction(InterstitialActionReceiver& recv);
};
//-------------------------------------------------------------------------//




//-------------------------------------------------------------------------//
// INTERFACE  SourceImageControllerParent                                  //
//-------------------------------------------------------------------------//
class  SourceImageControllerParent {

protected:

    SourceImageControllerParent( ) { }

public:

    virtual  ~SourceImageControllerParent( ) { }

    virtual  void  notifySourceImageInteractionStarted(
        SourceImageController& sender) = 0;
    virtual  void  notifySourceImageChanged(
        SourceImageController& sender) = 0;
    virtual  void  notifySourceImageInteractionFinished(
        SourceImageController& sender) = 0;

    virtual  HWND  dialogOverlayPeer( ) = 0;
};
//-------------------------------------------------------------------------//




//-------------------------------------------------------------------------//
// CLASS  PyramidLevelController                                           //
//-------------------------------------------------------------------------//
class PyramidLevelController
    : public virtual WorkPaneController {

private:

    static  const unsigned short  kDefaultPaneWidth = 196;
    static  const unsigned short  kDefaultPaneHeight = 27;
    static  const unsigned short  kTitleLabelWidth = 100;
    static  const unsigned short  kLevelLabelWidth = 20;
    static  const unsigned short  kDefaultButtonWidth = 24;
    static  const unsigned short  kDefaultNumLevels = 4;
    static  const unsigned short  kMaxNumLevels = 13;
    static  const unsigned short  kDefaultButtonSpacing = 8;

    PyramidLevelControllerParent*  fParent;
    WorkPaneView*                  fManagedView;
    HWND                           fTitleLabel;
    int                            fReadoutLeftEdge;
    HWND                           fLevelLabel;
    HWND                           fNextLevelButton;
    HWND                           fPrevLevelButton;
    int                            fButtonSpacing;
    int                            fButtonWidth;
    int                            fPyramidLevel;
    int                            fNumLevels;

    void  uIncrementPyramidLevel( );
    void  uDecrementPyramidLevel( );
    void  uWriteLevelToControls( );

public:

    PyramidLevelController(PyramidLevelControllerParent& parent,
        unsigned short numlevels = kDefaultNumLevels);
    virtual  ~PyramidLevelController( );

    void  installed(WorkPaneView& sender);
    void  deinstalled(WorkPaneView& sender);
    void  layout(WorkPaneView& sender);
    void  commandPropagated(WorkPaneView& sender,
        HWND commandSource, unsigned short commandID);
    void  viewEnabled(UIComponentView& sender);
    void  viewDisabled(UIComponentView& sender);
    int   pyramidLevel( ) const;
    void  setPyramidLevel(int lev);
    int   numLevels( ) const;
    void  setNumLevels(int levs);
    int   readoutLeftEdge( ) const;
    void  setReadoutLeftEdge(int le);
    int   buttonSpacing( ) const;
    void  setButtonSpacing(int spacing);
    int   buttonWidth( ) const;
    void  setButtonWidth(int bw);
    bool  isInstalled( ) const;
};
//-------------------------------------------------------------------------//




//-------------------------------------------------------------------------//
// INTERFACE  PyramidLevelControllerParent                                 //
//-------------------------------------------------------------------------//
class  PyramidLevelControllerParent {

protected:

    PyramidLevelControllerParent( ) { }

public:

    virtual  ~PyramidLevelControllerParent( ) { }

    virtual  void  notifyPyramidLevelChanged(PyramidLevelController&
        sender) = 0;
};
//-------------------------------------------------------------------------//




//-------------------------------------------------------------------------//
// CLASS  TrackerThingyController                                          //
//-------------------------------------------------------------------------//
class  TrackerThingyController
    : public virtual WorkPaneController {

private:

    TrackerThingyControllerParent*   fParent;
    WorkPaneView*                    fManaged;
    bool                             fIsInstalled;
    HWND                             fTitleLabel;
    HWND                             fValueTrackbar;
    HWND                             fValueEditArea;
    unsigned short                   fTitleWidth;
    unsigned short                   fEditAreaWidth;
    int                              fMinTrackVal;
    int                              fMaxTrackVal;
    unsigned short                   fTickIncrement;
    std::string                      fTitleText;
    int                              fTrackerValue;

    void  uProcessEditAreaChange( );
    void  uWriteValueToEditArea( );
    void  uWriteValueToTrackbar( );

public:

    static  const std::string      kDefaultTitleText;
    static  const unsigned short   kDefaultTitleWidth = 76;
    static  const unsigned short   kDefaultEditAreaWidth = 48;
    static  const int              kDefaultMinTrackVal = 0;
    static  const int              kDefaultMaxTrackVal = 8;
    static  const unsigned short   kDefaultTickIncrement = 1;

    TrackerThingyController(TrackerThingyControllerParent& par);
    virtual  ~TrackerThingyController( );

    void  installed(WorkPaneView& sender);
    void  deinstalled(WorkPaneView& sender);
    void  layout(WorkPaneView& sender);
    void  commandPropagated(WorkPaneView& sender,
        HWND commandSource, unsigned short commandID);
    int   trackerValue( ) const;
    void  setTrackerValue(int val);
    bool  isInstalled( ) const;
    unsigned short  titleWidth( ) const;
    void  setTitleWidth(unsigned short titlew);
    unsigned short  editAreaWidth( ) const;
    void  setEditAreaWidth(unsigned short eaw);
    int   maxTrackValue( ) const;
    void  setMaxTrackValue(int maxtrack);
    int   minTrackValue( ) const;
    void  setMinTrackValue(int mintrack);
    unsigned short  tickIncrement( ) const;
    void  setTickIncrement(unsigned short incr);
    const std::string&  titleText( ) const;
    void  setTitleText(const std::string& text);
};
//-------------------------------------------------------------------------//




//-------------------------------------------------------------------------//
// INTERFACE  TrackerThingyControllerParent                                //
//-------------------------------------------------------------------------//
class  TrackerThingyControllerParent {

protected:

    TrackerThingyControllerParent( ) { }

public:

    virtual  ~TrackerThingyControllerParent( ) { }

    virtual  void  notifyTrackerValueChanged(TrackerThingyController&
        sender) = 0;
};
//-------------------------------------------------------------------------//
