/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// S580Application.h                                                       //
//                                                                         //
// Packages the interface definition of class S580AppController only       //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// ver. 1.0.0 of Fri 09-Jan-2009 @ 5:10am EST                              //
//                                                                         //
//     this is the version used to compile to the 1.0pr1 distributable     //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// Copyright (c) 2008-2009 Lucas Stephen Beeler. All rights reserved.      //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef  S580_APPLICATION__HXX
#define  S580_APPLICATION__HXX

#include <ColorImaging.h>
#include "Studio580Types.h"
#include "Painting.h"

//-------------------------------------------------------------------------//
/* CLASS  S580AppController
   The application controller for Studio580 */
class  S580AppController :
    public virtual ApplicationController,
    public virtual DialogController {

private:

    std::auto_ptr<S580MainWinController>   fMainWinCtlr;
    std::auto_ptr<BrushManager>            fBrushManager;
    std::auto_ptr<NewDialogController>     fNewDialogCtlr;
    std::auto_ptr<EraserOptionsDialog>     fEraserOptsDialog;
    std::auto_ptr<BrushOptionsDialog>      fBrushOptsDialog;
    std::auto_ptr<Brush>                   fUnivBrush;
    ToolSpecifier                          fCurrentTool;
    PaintingDocument*                      fCurrentPainting;
    std::auto_ptr<Eraser>                  fCurrentEraser;

    void  uCreateChildren( );
    void  uDestroyChildren( );

public:

    S580AppController( );
    virtual  ~S580AppController( );

    void  installed(Application& sender);
    void  deinstalled(Application& sender);
    void  applicationStarted(Application& sender);
    void  applicationStopped(Application& sender);
    bool  applicationStopRequested(Application& sender);
    void  thingyItemActivated(DialogThingy&, int);
    void  thingyClosed(DialogThingy&);
    void  thingyInteractionStarted(DialogThingy&);
    void  thingyInteractionStopped(DialogThingy&);
    void  layoutSubthingies(CompositeThingy& sender);
    void  enableSubthingies(CompositeThingy& sender);
    void  disableSubthingies(CompositeThingy& sender);

    virtual  bool  isInstalled( ) const;
    virtual  BrushManager&  brushManager( );

    virtual  const ToolSpecifier&  currentTool( ) const;
    virtual  void  setCurrentTool(const ToolSpecifier&);

    virtual  void  newPainting( );
    virtual  void  closePainting( );
    virtual  bool  isPaintingOpen( ) const;
    virtual  PaintingDocument&  currentPainting( );
    virtual  const PaintingDocument&  currentPainting( ) const;
    virtual  void  openPainting( );

    virtual  void  changeEraserOptions( );
    virtual  Eraser&  eraser( );
    virtual  const Eraser&  eraser( ) const;

    virtual  Brush&  universalBrush( );
    virtual  const Brush&  universalBrush( ) const;

    virtual  void  changeBrushOptions( );

    virtual  ApplicationWindowThingy&  mainWindowView( );

    virtual  void  notifyBrushChanged( );
    virtual  void  notifyDocumentStateChanged( );
};
//-------------------------------------------------------------------------//

#endif
