/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// Painting.h                                                              //
//                                                                         //
// Packages the interface definitions of classes PaintingDocument and      //
// UndoPoint                                                               //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//  <unversioned module>                                                   //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// Copyright (c) 2008 Lucas Stephen Beeler. All rights reserved.           //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef PAINTING__HXX
#define PAINTING__HXX

#include <ColorImaging.h>
#include "Studio580Types.h"

class UndoPoint {

private:

    static  int         sNextSequenceNumber;
    static  UndoPoint*  sNullPoint;

    Rectangle2Di    fEffectsRegion;
    int             fSequenceNumber;

public:

    static  const UndoPoint&  nullPoint( );

    UndoPoint(int x, int y, int w, int h);
    UndoPoint(const Vector2Di& origin, int w, int h);
    UndoPoint(const Rectangle2Di fxreg);
    UndoPoint(const UndoPoint&);
    ~UndoPoint( );

    const UndoPoint&  operator=(const UndoPoint& rhs);
    bool  operator==(const UndoPoint& rhs) const;
    bool  operator!=(const UndoPoint& rhs) const;

    virtual  const Rectangle2Di&  effectsRegion( ) const;
};

class PaintingDocument {

private:

    std::auto_ptr<RGBAImage>     fImageBuffer;
    std::auto_ptr<RGBAImage>     fUndoBuffer;
    UndoPoint                    fUndoPoint;
    UndoPoint                    fRedoPoint;
    std::string                  fName;
    bool                         fIsMutated;

public:

    PaintingDocument(int, int);
    PaintingDocument(const Vector2Di&);
    PaintingDocument(const std::string&);

    virtual ~PaintingDocument( );

    virtual  int  width( ) const;
    virtual  int  height( ) const;
    virtual  Vector2Di  dimension( ) const;
    virtual  RGBAImage&  image( );
    virtual  const RGBAImage&  image( ) const;
    virtual  void  save( );
    virtual  void  saveAs(const std::string&);
    virtual  bool  isUndoAvailable( ) const;
    virtual  bool  isRedoAvailable( ) const;
    virtual  void  setUndoPoint(const Rectangle2Di&);
    virtual  void  undo( );
    virtual  void  redo( );
    virtual  const std::string&  name( ) const;
    virtual  bool  isMutated( ) const;
    virtual  void  setMutated( );
    virtual  bool  isMapped( ) const;
};

#endif
