/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// NewDialog.cpp                                                           //
//                                                                         //
// Implements methods in class NewDialogController only                    //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//  <unversioned module>                                                   //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// Copyright (c) 2008 Lucas Stephen Beeler. All rights reserved.           //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#include "NewDialog.h"
#include "resource.h"
#include "S580Application.h"
#include <sstream>

NewDialogController::NewDialogController(S580AppController& parent)
    : fParent(&parent)
{
      fView.reset(new DialogThingy(parent.mainWindowView( ), kNewDialogID));
      delete & fView->installController(*this);
}



NewDialogController::~NewDialogController( )
{
}



void  NewDialogController::layoutSubthingies(CompositeThingy& sender)
{
}



void  NewDialogController::enableSubthingies(CompositeThingy& sender)
{
}



void  NewDialogController::disableSubthingies(CompositeThingy& sender)
{
}



void  NewDialogController::thingyItemActivated(DialogThingy& sender,
    int itemID)
{
    fWasDataCaptured = false;

    if (itemID == kOkButtonControlID) {

        std::string  width_text = view( ).itemText(kWidthEntryControlID);
        std::istringstream  width_stream(width_text);
        int width;  width_stream >> width;

        std::string  height_text = view( ).itemText(kHeightEntryControlID);
        std::istringstream  height_stream(height_text);
        int height;  height_stream >> height;

        std::ostringstream  errormsg_stream;
        bool  error_occurred = false;
        if (width < kMinimumImageDimension) {

            errormsg_stream << "The image width youve entered is too small. "
                "Please enter a width value\ngreater than or equal to " <<
                kMinimumImageDimension << " pixels.";
            error_occurred = true;
        }
        else if (width > kMaximumImageDimension) {

            errormsg_stream << "The image width youve entered is too large. "
                "Please enter a width value\nless than or equal to " <<
                kMaximumImageDimension << " pixels.";
            error_occurred = true;
        }
        else if (height < kMinimumImageDimension) {

            errormsg_stream << "The image height youve entered is too small. "
                "Please enter a height value\ngreater than or equal to " <<
                kMinimumImageDimension << " pixels.";
            error_occurred = true;
        }
        else if (height > kMaximumImageDimension) {

            errormsg_stream << "The image height youve entered is too large. "
                "Please enter a height value\nless than or equal to " <<
                kMaximumImageDimension << " pixels.";
            error_occurred = true;
        }

        if (error_occurred) {

            MessageBox(sender.adapter( ).primitive( ),
                errormsg_stream.str( ).c_str( ),
                Application::instance( ).name( ).c_str( ),
                MB_ICONERROR);
            return;
        }

        fUserImageDimension = Vector2Di(width, height);
        fWasDataCaptured = true;

        sender.stopInteraction( );
    }
    else if (itemID == kCancelButtonControlID) {

        sender.stopInteraction( );
    }
}



void  NewDialogController::thingyClosed(DialogThingy&)
{
}



void  NewDialogController::thingyInteractionStarted(DialogThingy& sender)
{
    sender.themeItem(kWidthEntryControlID);
    sender.themeItem(kHeightEntryControlID);
    sender.themeItem(kWidthCaptionControlID);
    sender.themeItem(kHeightCaptionControlID);
    sender.themeItem(kHeaderTextControlID);
    sender.themeItem(kWidthMetricControlID);
    sender.themeItem(kHeightMetricControlID);
    sender.themeItem(kOkButtonControlID);
    sender.themeItem(kCancelButtonControlID);

    std::ostringstream  defdim_stream;
    defdim_stream << kDefaultImageDimension;

    sender.setItemText(kWidthEntryControlID, defdim_stream.str( ));
    sender.setItemText(kHeightEntryControlID, defdim_stream.str( ));
}



void  NewDialogController::thingyInteractionStopped(DialogThingy&)
{
}



bool  NewDialogController::runInteraction(Vector2Di& userdim)
{
    view( ).startInteraction( );

    if (fWasDataCaptured) {

        userdim = fUserImageDimension;
        return true;
    }
    else {
        
        return false;
    }
}



S580AppController&  NewDialogController::parent( )
{
    return *fParent;
}



DialogThingy&  NewDialogController::view( )
{
    return *fView;
}
