/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// Erasers.h                                                               //
//                                                                         //
// Packages the interface definitions of classes Eraser and EraserStroke   //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//  <unversioned module>                                                   //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// Copyright (c) 2008 Lucas Stephen Beeler. All rights reserved.           //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef  ERASERS__HXX
#define  ERASERS__HXX

#include "Studio580Types.h"

class Eraser {

private:

    static  const std::string  kPrefsFilename;
    static  const int          kMaxGeomSlots = 514;

    static  Eraser*            sDefaultEraser;
    static  RGBAImage*         sNoiseTexImage;

    static  void    sInitSharedState( );
    static  bool    uValidateWidth(int);
    static  bool    uValidateBlendPix(int, int);

    int             fWidth;
    int             fBlendPixels;
    bool            fIsEdgeNoiseEnabled;
    float           fGeometryData [kMaxGeomSlots];
    int             fNumGeomVerts;
    GPUInterface*   fGPU;
    GLuint          fVertexProgID;
    GLuint          fFragmentProgID;
    GLuint          fProgramSetID;
    GLuint          fNoiseTexID;
    GLint           fNoiseSamplerUnifLoc;
    GLint           fRadiusUnifLoc;
    GLint           fEnableNoiseUnifLoc;
    GLint           fBlendPixUnifLoc;

    void    uGenerateGeometry( );

    Eraser(int, int, bool);

public:

    static  const unsigned short  kMinWidth = 4;
    static  const unsigned short  kMaxWidth = 128;
    static  const unsigned short  kMinBlendPix = 1;

    static  const Eraser&  defaultEraser( );
    static  void           saveAsDefault(const Eraser&);

    Eraser( );
    Eraser(const Eraser&);
    virtual ~Eraser( );

    const Eraser&  operator=(const Eraser&);

    virtual  int            width( ) const;
    virtual  void           setWidth(int);
    virtual  int            blendPixels( ) const;
    virtual  void           setBlendPixels(int);
    virtual  bool           isEdgeNoiseEnabled( ) const;
    virtual  void           enableEdgeNoise( );
    virtual  void           disableEdgeNoise( );
    virtual  std::string    description( ) const;
    virtual  void           erase(const Vector2Di&);
    virtual  bool           isLinked( ) const;
    virtual  GPUInterface&  linkedGPU( ) const;
    virtual  void           link(GPUInterface&);
    virtual  void           unlink( );
};

#endif
