/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// BrushOptionsDialog.h                                                    //
//                                                                         //
// Packages the interface definition of class BrushOptionsDialog only      //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//  <unversioned module>                                                   //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// Copyright (c) 2008 Lucas Stephen Beeler. All rights reserved.           //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef  BRUSH_OPTIONS_DIALOG__HXX
#define  BRUSH_OPTIONS_DIALOG__HXX

#include "Studio580Types.h"
#include <memory>

class BrushOptionsDialog :
    public DialogController {

private:

    S580AppController*             fParent;
    std::auto_ptr<DialogThingy>    fView;
    std::string                    fFocusBrushSrcKey;
    std::auto_ptr<Brush>           fFocusBrush;
    bool                           fIsEditInProgress;

    void         uAddBrushListItem(const std::string&);
    int          uGetBrushListItemNumber(const std::string&);
    void         uSelectBrushListItem(const std::string&);
    void         uSelectBrushListItem(int);
    void         uSetSrcImgReadoutText(const std::string&);
    void         uSetSimMapReadoutText(const std::string&);
    void         uSetNameEditText(const std::string&);
    std::string  uGetBrushListItemText(int) const;
    std::string  uGetBrushListSelection( ) const;
    void         uSyncDisplayPaneToSelection( );
    void         uSetWidthReadoutValue(int);
    void         uInitWidthAssembly( );
    void         uInitBlendPixAssembly( );
    void         uSetWidthAssemblyValue(int);
    void         uSetBlendPixReadoutValue(int);
    void         uSetBlendPixAssemblyValue(int);
    void         uSetBlendPixRangeMax(int);
    void         uSetEdgeNoiseCheckState(bool);
    void         uProcessListBoxSelChange( );
    void         uProcessWidthSliderAction( );
    void         uProcessBlendSliderAction( );
    int          uGetWidthSliderValue( ) const;
    int          uGetBlendPixSliderValue( ) const;
    void         uSetBlendPixSliderValue(int);
    void         uProcessSetSourceClick( );
    void         uProcessSetSimMapClick( );
    void         uDisableRenameButton( );
    void         uEnableRenameButton( );
    void         uMakeDoneButtonDefault( );
    void         uMakeRenameButtonDefault( );
    void         uProcessNameEditAction( );
    void         uProcessRenameButtonClick( );
    void         uSaveFocusBrushData( );
    void         uClearBrushListBox( );
    void         uProcessNoiseCheckboxClick( );
    void         uProcessDoneButtonClick( );
    void         uProcessNewButtonClick( );
    void         uProcessDeleteButtonClick( );
    void         uPopulateBrushListBox( );
    void         uEnableDeleteButton( );
    void         uDisableDeleteButton( );
    void         uProcessCloneButtonClick( );
    void         uInitJumpParamAssembly( );
    void         uProcessJumpParamSliderAction( );
    float        uGetJumpParamSliderValue( ) const;
    void         uSetJumpParamReadoutValue(float);
    void         uSetJumpParamAssemblyValue(float);

public:

    BrushOptionsDialog(S580AppController&);
    virtual ~BrushOptionsDialog( );

    void  layoutSubthingies(CompositeThingy& sender);
    void  enableSubthingies(CompositeThingy& sender);
    void  disableSubthingies(CompositeThingy& sender);
    void  thingyItemActivated(DialogThingy&, int);
    void  thingyClosed(DialogThingy&);
    void  thingyInteractionStarted(DialogThingy&);
    void  thingyInteractionStopped(DialogThingy&);

    virtual  void  runInteraction( );
    virtual  S580AppController&  parent( );
};

#endif
