//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// SynthesisAgent.h                                                         //
//                                                                          //
// Packages the interface definition of class SynthesisAgent only           //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// ver. 2.0.0 of Fri 09-Jan-2009 @ 5:37am EST                               //
//                                                                          //
//     SynthesisAgent's now allow their clients to change their source      //
//     images and similarity maps dynamically, via public member functions. //
//     In the past, these were set once, in a SynthesisAgent's constructor, //
//     and remained fixed throughout an object's lifetime.                  //
//                                                                          //
// ver. 1.5.5 of Mon 1-Sep-2008 @ 10:55am EDT                               //
//                                                                          //
//     Made the synthesis shader's jump penalization parameter client       //
//     configurable                                                         //
//                                                                          //
// ver. 1.5.0 of Sun 31-Aug-2008 @ 10:52pm EDT                              //
//                                                                          //
//     Added a publicly accessible debugging method that draws the contents //
//     of the active work texture buffer. Texture-filtering options are now //
//     re-configured to be pixel-exact (GL_NEAREST) before the synthesis    //
//     passes are run. This aids interoperability with client code that     //
//     may change the filtering options arbitrarily.                        //
//                                                                          //
// prior change history elided; check out an older CVS rev to get it        //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// Copyright (c) 2008-2009, Lucas Stephen Beeler. All Rights Reserved.      //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#ifndef SYNTHESIS_AGENT__HXX
#define SYNTHESIS_AGENT__HXX

#include <PTCITypes.h>
#include <UserInteraction.h>
#include <GPUInterface.h>
#include <TextureSynthesis.h>
#include <string>
#include <vector>

class SynthesisAgent :
    public virtual InterstitialActionSender {

private:

    struct  InvariantUniformState {

        GLint    workTexExtentLoc;
        float    workTexExtent[2];
        GLint    sourceTexExtentLoc;
        float    sourceTexExtent[2];
        GLint    sourceTileOriginsLoc;
        float    sourceTileOrigins[16];
        GLint    sourceTileExtentsLoc;
        float    sourceTileExtents[8];
        GLint    simTexExtentLoc;
        float    simTexExtent[2];
        GLint    simNumEntriesLoc;
        float    simNumEntries;
        GLint    numRefinementLevelsLoc;
        int      numRefinementLevels;
        GLint    workTexLoc;
        int      workTex;
        GLint    sourceTexLoc;
        int      sourceTex;
        GLint    simTexLoc;
        int      simTex;
        GLint    stateTexLoc;
        int      stateTex;
        GLint    pixelWeightsLoc;
        GLint    jumpPenalizationParamLoc;
        float    jumpPenalizationParam;
    };

    struct  PerInvocationUniformState {

        GLint    upsampleEffectsGeomLoc;
        float    upsampleEffectsGeom[32];
        GLint    corr1EffectsGeomLoc;
        float    corr1EffectsGeom[20];
        GLint    corr2EffectsGeomLoc;
        float    corr2EffectsGeom[20];
        GLint    maxOutputEffectsGeomLoc;
        float    maxOutputEffectsGeom[4];
    };

    enum  OperationMode {
        
        kUpsampleJitterMode = 0,
        kCorrectionMode = 2,
        kOutputMode = 3,
    };

    static  const Vector2Df  kUpsampleOutsets[ ];
    static  const Vector2Df  kCorr1Outsets[ ];
    static  const Vector2Df  kCorr2Outsets[ ];

    InterstitialActionReceiverSet    fReceiverSet;
    GPUInterface&                    fGPU;
    RGBAImage*                       fSourceMosaicTex;
    GLuint                           fSourceMosaicTexID;
    const PyramidalSimilarityMap*    fSimMap;
    GLuint                           fSimMapMosaicTexID;
    InvariantUniformState*           fInvarUnifState;
    PerInvocationUniformState*       fPerInvocUnifState;
    GLuint                           fVertexProgID;
    GLuint                           fFragmentProgID;
    GLuint                           fProgramSetID;
    TextureBuffer*                   fActiveWorkTexBuffer;
    TextureBuffer*                   fAltWorkTexBuffer;
    GLuint                           fStateCacheTexID;
    int                              fPrecursorQuantization;

    void    uConstructorHelper(const RGBAImage& preimg);
    void    uConfigureTextures( );
    void    uLoadDiskResources( );
    void    uRenderEffectsRegion(float x, float y, float w, float h);
    void    uRunUpsampleJitterPass(int reflev);
    void    uRunCorrectionPasses(int reflev);
    void    uRunMaxOutputPass(int x, int y, int w, int h);
    void    uComputeEffectsRegions(PerInvocationUniformState& state, int x,
        int y, int w, int h);
    GLuint  uDownloadTexture1D(const std::vector<Vector2Df> texdata);
    void    uUpdateTexture1D(GLuint texid, std::vector<Vector2Df> texdata);
    void    uSwapWorkTexBuffers( );
    void    uConfigureInvariantLocs(InvariantUniformState& state);
    void    uWriteInvariantUnifState(InvariantUniformState& state);
    void    uConfigurePerInvocationLocs(PerInvocationUniformState& state);
    void    uWritePerInvocationUnifState(PerInvocationUniformState& state);
    void    uRebindInvariantTextures( );

public:

    static  const unsigned short  kWorkTexExtent = 512;
    static  const float           kOutTexPixelFraction;
    static  const float           kDefaultJumpParameter;

    SynthesisAgent(const RGBAImage& srcimg, GPUInterface& gpui,
        const PyramidalSimilarityMap& simmap);
    SynthesisAgent(const RGBAImage& srcimg, GPUInterface& gpui,
        const PyramidalSimilarityMap& simmap,
        InterstitialActionReceiver& iar);

    virtual ~SynthesisAgent( );

    virtual  GLuint  synthesize(int x, int y, int width, int height);
    void  registerReceiver(InterstitialActionReceiver& recv);
    void  deregisterReceiver(InterstitialActionReceiver& recv);
    void  cancelAction(InterstitialActionReceiver& recv);
    virtual  int    numRefinementLevels( ) const
        { return fInvarUnifState->numRefinementLevels; }
    virtual  int    precursorQuantization( ) const
        { return fPrecursorQuantization; }
    virtual  float  jumpParameter( ) const;
    virtual  void   setJumpParameter(float);
    virtual  void   setSimilarityMap(const PyramidalSimilarityMap&);
    virtual  void   setSourceImage(const RGBAImage&);

    virtual  void  dbgDrawActiveBuffer( ) const;
};

#endif
