//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// StatisticalTools.h                                                       //
//                                                                          //
// Defines the StatisticalTools class.                                      //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// ver. 1.0.0 of Wed 16-May-2007 @ 9:50pm EDT                               //
//                                                                          //
//     Adapted directly from Studio580 version.                             //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// Copyright (c) 2007, Lucas Stephen Beeler. All Rights Reserved.           //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#ifndef STATISTICAL_TOOLS__HXX
#define STATISTICAL_TOOLS__HXX

#include <cstdlib>
#include <ctime>

class StatisticalTools {

private:

    static  bool  sIsRandomizerSeeded;

    StatisticalTools( );

public:

    ~StatisticalTools( );

/** given a lower-bound value 'm' and an upper-bound value 'n', sample
    the closed interval [m, n] uniformly and return the randomly sampled
    value to the caller */
    template<typename TBounds>
    static  TBounds  sampleUniform(const TBounds& m, const TBounds& n)
    {
        if (!sIsRandomizerSeeded) {

            std::srand(std::time(0));
            sIsRandomizerSeeded = true;
        }

        float  r_float = ((float) std::rand( )) / ((float) RAND_MAX);
        float  m_float = (float) m;
        float  n_float = (float) n;

        TBounds result = (TBounds)(m_float + ((n_float - m_float) * r_float));

        return result;
    }
};

#endif