//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// SaveFileChooser.cpp                                                      //
//                                                                          //
// Implements methods in the SaveFileChooser class.                         //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// ver. 1.0.0 of Sat 18 Oct 2008 @ 9:06pm EDT                               //
//                                                                          //
//     Stable revision; class SaveFileChooser functions as specified        //
//                                                                          //
// ver. 0.1.0 of Wed 16-May-2007 @ 9:50pm EDT                               //
//                                                                          //
//     Adapted directly from Studio580 version -- not a stable version --   //
//     SaveFileChooser isn't implemented at this time.                      //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// Copyright (c) 2007-2008, Lucas Stephen Beeler. All Rights Reserved.      //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#include "SaveFileChooser.h"
#include "UIThingies.h"
#include "CanvasWindow.h"

/* stops the MSVC 2003 & 2005 compilers from propogating annoying warnings
   about the security risks present in the ANSI C standard library */
#pragma warning(disable : 4996)


SaveFileChooser::SaveFileChooser( )
{
}



SaveFileChooser::~SaveFileChooser( )
{
}



std::string  SaveFileChooser::runFileChoiceInteraction( )
{
    uPopulateTypeMaskBuffer( );

    if (GetSaveFileName (&fFeaturesDescriptor))
        return std::string(fFeaturesDescriptor.lpstrFile);
    else
        return std::string("");
}




std::string  SaveFileChooser::runFileChoiceInteraction(CanvasWindowView& win)
{
    fFeaturesDescriptor.hwndOwner = win.peerHandle( );

    std::string result = this->runFileChoiceInteraction( );

    fFeaturesDescriptor.hwndOwner = 0;

    return result;
}




std::string  SaveFileChooser::runFileChoiceInteraction(HWND win)
{
    fFeaturesDescriptor.hwndOwner = win;

    std::string result = this->runFileChoiceInteraction( );

    fFeaturesDescriptor.hwndOwner = 0;

    return result;
}



std::string  SaveFileChooser::runFileChoiceInteraction(const Thingy& t)
{
    const ThingyAdapterClient& tac =
        dynamic_cast<const ThingyAdapterClient&>(t);

    ThingyAdapterClient&  tac_mutable =
        const_cast<ThingyAdapterClient&>(tac);

    return runFileChoiceInteraction(tac_mutable.adapter( ).primitive( ));
}
