//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// PTCITypes.h                                                              //
//                                                                          //
// Provides incomplete type specifications for all classes in the Power     //
// Tools for Color Imaging (PTCI) class family. Defines universal           //
// "lightweight types" (i.e. structs, enums, and typedefs) used throughout  //
// the PTCI system.                                                         //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// ver 3.1.0 of Mon 22-Sep-2008 @ 11:55pm EDT                               //
//                                                                          //
//    Added type specs for classes GLCanvasThingy, GLCanvasController,      //
//    DialogThingy, and DialogController. Added the "lightweight types"     //
//    section defining various lightweight types used throughout PTCI.      //
//    Updated module header comments.                                       //
//                                                                          //
// ver 3.0.5 of Mon 01-Sep-2008 @ 7:05pm EDT                                //
//                                                                          //
//    Added type specs for classes ApplicationWindowThingy and              //
//    ApplicationWindowController                                           //
//                                                                          //
// ver 3.0.4 of Mon 28-Jul-2008 @ 9:26am EDT                                //
//                                                                          //
//    Added type spec for class TextureBuffer                               //
//                                                                          //
// older change history elided; check out an older CVS rev to get it        //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// Copyright (c) 2007-2008, Lucas Stephen Beeler. All Rights Reserved.      //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#ifndef PTCI_TYPES__HXX
#define PTCI_TYPES__HXX

#include <AffineGeometry.h>
#include <Win32Support.h>

//-------------------------------------------------------------------------//
// INCOMPLETE TYPE SPECIFICATIONS                                          //
//-------------------------------------------------------------------------//
class  CanvasWindowView;
class  FileChooser;
class  GDICanvasWindowView;
class  GLCanvasWindowView;
class  GDICanvasWindowController;
class  GLCanvasWindowController;
class  OpenFileChooser;
class  SaveFileChooser;
class  Win32Tools;
class  Application;
class  TranscriptionServer;
class  ApplicationController;
class  WorkPaneView;
class  WorkPaneController;
struct RGBColor;
class  RGBAImage;
class  Convolver;
class  ImageTools;
class  ConvolverFactory;
class  ContinuousConvolver;
class  GPUInterface;
class  InteractionToken;
class  MouseInteractionToken;
class  InterstitialActionToken;
class  ModalDialogView;
class  ModalDialogController;
class  TextureSpace;
class  SimpleTextureSpace;
class  InterstitialActionSender;
class  InterstitialActionReceiver;
class  PixelNeighborhood;
class  ImagePyramid;
class  UIComponentView;
class  UIComponentController;
class  SynthesisAgent;
class  StructuredReader;
class  ImageSimilarityMap;
class  Thingy;
class  ThingyController;
class  CompositeThingy;
class  CompositeThingyController;
class  ThingyAdapter;
class  ThingyAdapterClient;
class  ApplicationPaneThingy;
class  ApplicationPaneController;
class  PushButtonThingy;
class  PushButtonController;
class  GroupBoxThingy;
class  SliderThingy;
class  SliderController;
class  CheckBoxThingy;
class  CheckBoxController;
class  TextEntryThingy;
class  HorizontalSeparatorThingy;
class  MapPicker;
class  SourceImageChooserThingy;
class  SourceImageChooserController;
class  TextureBuffer;
class  ApplicationWindowThingy;
class  ApplicationWindowController;
class  GLCanvasThingy;
class  GLCanvasController;
class  DialogThingy;
class  DialogController;
//-------------------------------------------------------------------------//



//-------------------------------------------------------------------------//
// UNIVERSAL LIGHTWEIGHT TYPES                                             //
//-------------------------------------------------------------------------//
enum           ScrollbarSelector { kHorizontalScrollbar,
    kVerticalScrollbar };
enum           ToolbarButtonKind  { kPushButtonKind, kSelectButtonKind };
typedef  long  ToolbarButtonToken;
typedef  int   StatusBarPaneToken;
//-------------------------------------------------------------------------//

#endif
