//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// OpenFileChooser.h                                                        //
//                                                                          //
// Defines the OpenFileChooser class.                                       //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// ver. 1.1.0 of Sat 18 Oct 2008 @ 9:19pm EDT                               //
//                                                                          //
//     Added & implemented an overload of method runFileChoiceInteraction   //
//     taking a single Thingy& reference-valued argument to be compliant    //
//     with the interface required by superclass FileChooser                //
//                                                                          //
// ver. 1.0.0 of Wed 16-May-2007 @ 9:50pm EDT                               //
//                                                                          //
//     Adapted directly from Studio580 version.                             //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// Copyright (c) 2007-2008, Lucas Stephen Beeler. All Rights Reserved.      //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#ifndef OPEN_FILE_CHOOSER__HXX
#define OPEN_FILE_CHOOSER__HXX

#include <FileChooser.h>

class OpenFileChooser : public virtual FileChooser {

public:

    OpenFileChooser( );
    virtual ~OpenFileChooser( );

    std::string  runFileChoiceInteraction( );
    std::string  runFileChoiceInteraction(CanvasWindowView& win);
    std::string  runFileChoiceInteraction(HWND win);
    std::string  runFileChoiceInteraction(const Thingy&);
};

#endif
