//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// OpenFileChooser.cpp                                                      //
//                                                                          //
// Implements methods in the OpenFileChooser class.                         //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// ver. 1.1.0 of Sat 18 Oct 2008 @ 9:19pm EDT                               //
//                                                                          //
//     Added & implemented an overload of method runFileChoiceInteraction   //
//     taking a single Thingy& reference-valued argument to be compliant    //
//     with the interface required by superclass FileChooser                //
//                                                                          //
// ver. 1.0.0 of Wed 16-May-2007 @ 9:50pm EDT                               //
//                                                                          //
//     Adapted directly from Studio580 version.                             //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// Copyright (c) 2007-2008, Lucas Stephen Beeler. All Rights Reserved.      //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#include "OpenFileChooser.h"
#include "CanvasWindow.h"
#include "UIThingies.h"

/* stops the MSVC 2003 & 2005 compilers from propogating annoying warnings
   about the security risks present in the ANSI C standard library */
#pragma warning(disable : 4996)


OpenFileChooser::OpenFileChooser( )
{
}




OpenFileChooser::~OpenFileChooser( )
{
}




std::string  OpenFileChooser::runFileChoiceInteraction( )
{
    uPopulateTypeMaskBuffer( );

    if (GetOpenFileName(&fFeaturesDescriptor))
        return std::string(fFeaturesDescriptor.lpstrFile);
    else
        return std::string("");
}




std::string  OpenFileChooser::runFileChoiceInteraction(CanvasWindowView& win)
{
    fFeaturesDescriptor.hwndOwner = win.peerHandle( );

    std::string result = this->runFileChoiceInteraction( );

    fFeaturesDescriptor.hwndOwner = 0;

    return result;
}




std::string  OpenFileChooser::runFileChoiceInteraction(HWND win)
{
    fFeaturesDescriptor.hwndOwner = win;

    std::string result = this->runFileChoiceInteraction( );

    fFeaturesDescriptor.hwndOwner = 0;

    return result;
}



std::string  OpenFileChooser::runFileChoiceInteraction(const Thingy& t)
{
    const ThingyAdapterClient& tac =
        dynamic_cast<const ThingyAdapterClient&>(t);

    ThingyAdapterClient&  tac_mutable =
        const_cast<ThingyAdapterClient&>(tac);

    return runFileChoiceInteraction(tac_mutable.adapter( ).primitive( ));
}
