//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// FileChooser.cpp                                                          //
//                                                                          //
// Implements methods in the FileChooser interface.                         //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// ver. 1.1.0 of Sat 18 Oct 2008 @ 9:10pm EDT                               //
//                                                                          //
//     Added another overload of method runFileChoiceInteraction( ) that    //
//     takes a Thingy& reference argument specifying the Thingy that owns   //
//     the file chooser popup window.                                       //
//                                                                          //
// ver. 1.0.0 of Wed 16-May-2007 @ 9:50pm EDT                               //
//                                                                          //
//     Adapted directly from Studio580 version.                             //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// Copyright (c) 2007-2008, Lucas Stephen Beeler. All Rights Reserved.      //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#include "FileChooser.h"
#include <cstring>
#include <cstdio>
#include <stdarg.h>

/* stops the MSVC 2003 & 2005 compilers from propogating annoying warnings
   about the security risks present in the ANSI C standard library */
#pragma warning(disable : 4996)

const  std::string  FileChooser::kDone = "FileChooser_done";
const  char*  FileChooser::kGenericFiletypeMask = "All Files\0*.*\0\0"; 

FileChooser::FileChooser( )
{
    std::strcpy(fDialogTitle, "Choose a File");
    fNameBuffer[0] = '\0';
    std::memcpy(fTypeMaskBuffer, kGenericFiletypeMask, 18);

    fFeaturesDescriptor.lStructSize = sizeof(OPENFILENAME);
    fFeaturesDescriptor.hwndOwner = 0;
    fFeaturesDescriptor.hInstance = 0;
    fFeaturesDescriptor.lpstrFilter = fTypeMaskBuffer;
    fFeaturesDescriptor.lpstrCustomFilter = 0;
    fFeaturesDescriptor.nMaxCustFilter = 0;
    fFeaturesDescriptor.nFilterIndex = 1;
    fFeaturesDescriptor.lpstrFile = fNameBuffer;
    fFeaturesDescriptor.nMaxFile = _MAX_PATH - 1;
    fFeaturesDescriptor.lpstrFileTitle = 0;
    fFeaturesDescriptor.nMaxFileTitle = 0;
    fFeaturesDescriptor.lpstrInitialDir = 0;
    fFeaturesDescriptor.lpstrTitle = fDialogTitle;
    fFeaturesDescriptor.Flags = 0;
    fFeaturesDescriptor.nFileOffset = 0;
    fFeaturesDescriptor.nFileExtension = 0;
    fFeaturesDescriptor.lpstrDefExt = 0;
    fFeaturesDescriptor.lCustData = 0;
    fFeaturesDescriptor.lpfnHook = 0;
    fFeaturesDescriptor.lpTemplateName = 0;
}




FileChooser::~FileChooser( )
{
}




std::string  FileChooser::title( ) const
{
    return std::string(fDialogTitle);
}




void  FileChooser::setTitle(const std::string& t)
{
    if (t.length( ) < 256) {

        std::strcpy(fDialogTitle, t.c_str( ));
    }
    else {

        std::memcpy(fDialogTitle, t.c_str( ), 255);
        fDialogTitle[255] = '\0';
    }
}




void  FileChooser::addFiletypeMask(const std::string& uniqueDesc,
    const std::string& ext0)
{
    std::vector<std::string>  extnSet;

    TFiletypeTable::const_iterator  finder = fFiletypeTable.find(uniqueDesc);
    if (finder != fFiletypeTable.end( ))
        extnSet = fFiletypeTable[uniqueDesc];

    extnSet.push_back(ext0);

    fFiletypeTable[uniqueDesc] = extnSet;
}




void  FileChooser::removeFiletypeMask(const std::string&)
{
    throw std::runtime_error("FileChooser: removeFiletypeMask( ) feature not "
        "implemented in this release");
}




void  FileChooser::uPopulateTypeMaskBuffer( )
{
    if (fFiletypeTable.empty( )) {

        std::memcpy(fTypeMaskBuffer, kGenericFiletypeMask, 18);
    }
    else {

        char*  typemaskBufPtr = & fTypeMaskBuffer[0];

        TFiletypeTable::const_iterator i = fFiletypeTable.begin( );
        while (i != fFiletypeTable.end( )) {

            /* copy the filetype description string for the current filetype
               into the Win32 typemask (or "filter") buffer and advance the
               buffer pointer appropriately */
            std::string  typeDesc = i->first;
            std::strcpy(typemaskBufPtr, typeDesc.c_str( ));
            typemaskBufPtr += typeDesc.length( );
            typemaskBufPtr++;

            /* loop over all the *.xxx... file extension strings associated
               with this filetype in the type table and copy them into the
               Win32 filter buffer */
            for (unsigned j = 0; j < i->second.size( ); j++) {

                std::strcpy(typemaskBufPtr, i->second[j].c_str( ));
                typemaskBufPtr += i->second[j].length( );

                /* if the current file extension string isn't the last one in
                   the set, then we have to replace the '\0' character dropped
                   in by strcpy with a ';' character to meet the Win32 filter
                   buffer encoding guidelines; if the current file extension
                   string is the last one in the set, however, we can just
                   leave the '\0' character there, since Win32 uses the
                   single '\0' character to separate type-extension set
                   pairs */
                if (j != (i->second.size( ) - 1))
                    *typemaskBufPtr = ';';

                /* advance the buffer pointer to be ready to the next
                   position */
                typemaskBufPtr++;
            } // for loop

            /* advance the iterator */
            i++;
        } // while loop

        *typemaskBufPtr = '\0';
    }
}
