//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// CanvasWindow.h                                                           //
//                                                                          //
// Pacakges the class definiton for class CanvasWindowView only             //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// version 2.5.2 of Tue 20 May 2008 @ 2:16pm EDT                            //
//                                                                          //
//    added ShowWindow( ) calls immediately following calls to widget       //
//    factory creation routines; this was necessitated by changes in the    //
//    Win32Support module that caused the widget factory to create          //
//    initially hidden widgets                                              //
//                                                                          //
// version 2.5.1 of Fri 3 May 2008 @ 7:33pm EDT                             //
//                                                                          //
//    changed all references of class template Vertex2D to Vector2D; see    //
//    the AffineGeometry module's header for more info                      //
//                                                                          //
// ver. 2.5.0 of Fri 15-Feb-2008 @ 11:27pm EST                              //
//                                                                          //
//    Added progress bar support, child management support, enable-disable  //
//    functionality, and wait state support.                                //
//                                                                          //
// ver. 2.0.0 of Thu 27-Sep-2007 @ 4:59pm EDT                               //
//                                                                          //
//    This file has been around for months and has seen several evolutions  //
//    through CVS commit cycles of projects GPUISupport and PyramidBuilder, //
//    however this current version 2.0.0 is the first formal "version"      //
//    of the file and is considered stable.                                 //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// Copyright (c) 2007-2008 Lucas Stephen Beeler. All Rights Reserved.       //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#ifndef CANVAS_WINDOW__HXX
#define CANVAS_WINDOW__HXX

#include <Win32Support.h>
#include <AffineGeometry.h>
#include <PTCITypes.h>
#include <UserInteraction.h>
#include <string>
#include <stdexcept>
#include <set>

class CanvasWindowView
    : public virtual UIComponentView {

private:

    static  bool  sAreWindowClassesRegistered;
    static  void  sRegisterWindowClasses( );
    static  const std::string  kWindowClassName;
    static  const std::string  kCanvasClassName;

    static LRESULT WINAPI sWindowProc(HWND targetWindow, UINT messageCode,
        WPARAM wParam, LPARAM lParam);
    static LRESULT WINAPI sCanvasProc(HWND targetWindow, UINT messageCode,
        WPARAM wParam, LPARAM lParam);
    static  CanvasWindowView*  sGetObject(HWND w);

    void  uLayoutChildren( );
    void  uEnableStatusRegion( );
    void  uDisableStatusRegion( );

protected:

    static  const unsigned short  kDefaultLeftMargin = 16;
    static  const unsigned short  kDefaultRightMargin = 16;
    static  const unsigned short  kDefaultTopMargin = 16;
    static  const unsigned short  kDefaultBottomMargin = 16;
    static  const Vector2Di       kDefaultPosition;
    static  const unsigned short  kDefaultWidth = 640;
    static  const unsigned short  kDefaultHeight = 480;
    static  const unsigned short  kDefaultMinHorizTrackSize = 512;
    static  const unsigned short  kDefaultMinVerticalTrackSize = 384;
    static  const unsigned short  kCanvasWindowChildID = 1024;
    static  const unsigned short  kResizeGripWindowChildID = 1025;
    static  const unsigned short  kInfoAreaChildID = 1026;
    static  const unsigned short  kProgressBarChildID = 1027;
    static  const unsigned short  kStatusRegionDividerChildID = 1028;
    static  const unsigned short  kSizeGripPixelSize = 14;
    static  const unsigned short  kStatusRegionHeight = 28;

    unsigned short  fLeftMargin;
    unsigned short  fRightMargin;
    unsigned short  fTopMargin;
    unsigned short  fBottomMargin;
    unsigned short  fMinVerticalTrackSize;
    unsigned short  fMinHorizTrackSize;
    unsigned short  fStatusRegionHeight;
    HWND            fMainWindowPrimitive;
    HWND            fCanvasWindowPrimitive;
    HWND            fResizeGripWindowPrimitive;
    HWND            fInfoAreaPrimitive;
    HWND            fProgressBarPrimitive;
    HWND            fStatusRgnDivPrimitive;
    bool            fIsWindowVisible;
    bool            fIsWindowEnabled;
    bool            fIsWindowWaiting;
    std::set<HWND>  fChildSet;
    std::set<HWND>  fAutoEnableSet;

    virtual  LRESULT  uProcessWindowMessage(HWND targetWindow,
        UINT messageCode, WPARAM wParam, LPARAM lParam);
    virtual  LRESULT  uProcessCanvasMessage(HWND targetWindow,
        UINT messageCode, WPARAM wParam, LPARAM lParam);

public:

    static  const unsigned short  kChildID0 = 2048;

    CanvasWindowView(const std::string& title);
    virtual ~CanvasWindowView( );
    
    virtual  std::string  title( ) const;
    virtual  void  setTitle(const std::string& s);
    virtual  unsigned short  width( ) const;
    virtual  void  setWidth(unsigned short w);
    virtual  unsigned short  height( ) const;
    virtual  void  setHeight(unsigned short h);
    virtual  unsigned short  clientWidth( ) const;
    virtual  unsigned short  clientHeight( ) const;
    virtual  Vector2Di  position( ) const;
    virtual  void  setPosition(const Vector2Di& p);
    virtual  HWND  peerHandle( );
    virtual  HWND  canvasPeerHandle( );
    virtual  unsigned short  leftMargin( ) const;
    virtual  void  setLeftMargin(unsigned short lm);
    virtual  unsigned short  rightMargin( ) const;
    virtual  void  setRightMargin(unsigned short rm);
    virtual  unsigned short  topMargin( ) const;
    virtual  void  setTopMargin(unsigned short tm);
    virtual  unsigned short  bottomMargin( ) const;
    virtual  void  setBottomMargin(unsigned short bm);
    virtual  void  invalidate( );
    virtual  void  show( );
    virtual  void  hide( );
    virtual  bool  isVisible( ) const;
    virtual  void  enable( );
    virtual  void  disable( );
    virtual  bool  isEnabled( ) const;
    virtual  void  wait( );
    virtual  void  unwait( );
    virtual  bool  isWaiting( ) const;
    virtual  void  manageChild(HWND c);
    virtual  void  unmanageChild(HWND c);
    virtual  bool  isChildManaged(HWND c) const;
    virtual  unsigned short  minHorizTrackSize( ) const;
    virtual  void  setMinHorizTrackSize(unsigned short mhs);
    virtual  unsigned short  minVerticalTrackSize( ) const;
    virtual  void  setMinVerticalTrackSize(unsigned short mvs);
    virtual  unsigned short  canvasClientWidth( ) const;
    virtual  unsigned short  canvasClientHeight( ) const;
    virtual  unsigned short  canvasWidth( ) const;
    virtual  unsigned short  canvasHeight( ) const;
    virtual  void  enableInfoArea( );
    virtual  void  disableInfoArea( );
    virtual  bool  isInfoAreaEnabled( ) const;
    virtual  std::string  infoAreaText( ) const;
    virtual  void  setInfoAreaText(const std::string& s);
    virtual  void  enableProgressBar( );
    virtual  void  disableProgressBar( );
    virtual  bool  isProgressBarEnabled( ) const;
    virtual  void  setPercentProgress(int pctprog);
    virtual  unsigned short  statusRegionHeight( ) const;
};

#endif
