//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// Application.h                                                            //
//                                                                          //
// Defines the Application class and the ApplicationController interface.   //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// ver. 1.3.0 of Fri 07-Nov-2008 @ 6:39pm EDT                               //
//                                                                          //
//     Added accelerator key focus window management                        //
//                                                                          //
// ver. 1.2.0 of Fri 24-Oct-2008 @ 6:12pm EDT                               //
//                                                                          //
//     Application objects now maintain the path of the directory in which  //
//     they were launched, and provide a method for clients to access this  //
//     information.                                                         //
//                                                                          //
// ver. 1.1.1 of Mon 12-May-2008 @ 7:19pm EDT                               //
//                                                                          //
//     Changed const qualifiers on intersitial action related methods       //
//     in accordance with the interface changes in the UserInteraction      //
//     module                                                               //
//                                                                          //
// older change history elided; check out an older CVS rev to get it        //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// Copyright (c) 2007-2008, Lucas Stephen Beeler. All Rights Reserved.      //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#ifndef APPLICATION__HXX
#define APPLICATION__HXX

#include <Win32Support.h>
#include <PTCITypes.h>
#include <UserInteraction.h>
#include <string>


class ApplicationController {

protected:

    ApplicationController( );

public:

    static  ApplicationController*  nullController( );

    virtual ~ApplicationController( );

    virtual  void  installed(Application& sender) = 0;
    virtual  void  deinstalled(Application& sender) = 0;
    virtual  void  applicationStarted(Application& sender) = 0;
    virtual  void  applicationStopped(Application& sender) = 0;
    virtual  bool  applicationStopRequested(Application& sender) = 0;
};







class Application : public virtual InterstitialActionReceiver {

private:

    static Application*  sSingletonInstance;

    std::string                     fApplicationName;
    std::string                     fStartupDir;
    TranscriptionServer*            fTransServer;
    bool                            fIsRunning;
    ApplicationController*          fController;
    HINSTANCE                       fSysModule;
    const ApplicationWindowThingy*  fKeyFocus;
    
public:

/** note that this constructor can only be invoked once during program
    execution */
    Application(const std::string& appname, HINSTANCE sysmod);
    virtual ~Application( );

/** singleton instance accessor function */
    static  Application&  instance( );

/** begins running the main event loop of the application on which it is
    invoked. The event loop will continue to run and the application will
    continue to execute until terminate( ) is called. */
    virtual  void  start( );

/** terminates program execution immediately, and returns "resultCode" to
    the host operating system. */
    virtual  void  terminate(int resultCode);

/** gracefully stops program execution by first requesting permission from
    the currently installed controller object to stop execution (this
    gives the controller the opportunity to ask the user if he's sure he
    wants to quit, etc.). If the controller object denies the stop request,
    this method returns immediately without any effect. If, however, the
    controller object confirms the request, system resources are freed,
    the controller is notified that the application has stopped,
    and terminate(0) is called */
    virtual  void  stop( );
   
/** returns true if the application has been started, false otherwise */
    virtual  bool  isRunning( );

/** returns a reference to the TranscriptionServer instance used by this
    application to transcribe error and diagnostic information at runtime */
    virtual  TranscriptionServer&  transcriptionServer( );

/** returns a reference to the currently installed controller */
    virtual  ApplicationController&  controller( );

/** installs 'ctlr' to serve as the new applictation controller for this
    application, then returns a reference to whatever object was
    previously installed */
    virtual  ApplicationController&  installController(
        ApplicationController& ctlr);

/** returns a handle to this Win32 executable module in which this
    application is running */
    virtual  HINSTANCE  systemModule( );

/** runs the application's event loop in response to an interstitial action
    event */
    virtual  void  interstitialActionEvent(InterstitialActionSender& sender,
        const InterstitialActionToken& evt);

/** returns the name of the application */
    virtual  const std::string&  name( ) const;

/** returns the complete path to the directory where the application was
    launched */
    virtual  const std::string&  startupDirectory( ) const;

/** make 'target' the window that will be notified when an accelerator key
    combination (ex: Ctrl+X for Exit Application) is pressed */
    virtual  void  setKeyFocus(const ApplicationWindowThingy& target);

/** clears the current accelerator key focus window if one has been
    previously set via a call to setKeyFocus; if the current key focus
    is clear, no notification is sent when an accelerator key combination
    is pressed */
    virtual  void  clearKeyFocus( );

/** returns true if the accelerator key focus is currently set to some
    window, and false if the key focus is currently clear */
    virtual  bool  isKeyFocusSet( ) const;

/** returns a reference to the window that currently has the accelerator
    key focus, or throws a logic_error exception if no key focus window
    is currently set */
    virtual  const ApplicationWindowThingy&  keyFocus( ) const;
};

#endif