/*

 SceneIntrinsics.c

 Copyright (c) 2006, Lucas Stephen Beeler. All Rights Reserved.

 */

#include "MaterialProps.h"
#include "Mesh.h"
#include "Camera.h"
#include "LightingIntrinsics.h"
#include "SpatialPartitioning.h"

#ifndef SCENE_INTRINSICS__H
#define SCENE_INTRINSICS__H

struct gel_rep {

    Mesh*                     gelMesh;
    MaterialProps             gelProps;
    HomogeneousTransform3D    gelTrans;
    HomogeneousTransform3D    invGelTrans;
    BoundingBox3D             boundingBox;
    BoundingVolumeHierarchy*  gelBVH;
};
typedef struct gel_rep Gel;

void   SetGel(Gel*, const Mesh*, const MaterialProps*, const HomogeneousTransform3D*);
void   TransformGel(Gel*, const HomogeneousTransform3D*);

struct Scene_rep {

    Camera     eye;
    unsigned   numGels;
    unsigned   gelsAllocd;
    Gel*       gelData;
    RGBColor   ambientIntensity;
    unsigned   numLights;
    unsigned   lightsAllocd;
    Light*     lightData;
};
typedef struct Scene_rep Scene;

Scene*   ConstructBaseScene(void);
void     AddGel(Scene*, const Gel*);
void     AddLight(Scene*, const Light*);

#endif
