/*

 RayEngine.h

 Copyright (c) 2006-2007, Lucas Stephen Beeler. All Rights Reserved.

 */

#ifndef  RAY_ENGINE__H
#define  RAY_ENGINE__H

#include "Imaging.h"
#include "SceneIntrinsics.h"
#include <math.h>

struct IntersectionRecord_REP {

    HomogeneousVector3D   position;
    HomogeneousVector3D   normal;
    HomogeneousVector3D   inbound;
    MaterialProps         surfaceMaterial;
    double                tParameter;
};

typedef struct IntersectionRecord_REP IntersectionRecord;

void      TraceScene(const Scene*, Image*);
RGBColor  Trace(const Ray3D*, const Scene*, unsigned);
boolean   SceneIntersectFront(const Scene*, const Ray3D*, IntersectionRecord*);
boolean   GelIntersectFront(const Gel*, const Ray3D*, IntersectionRecord*);
boolean   SceneIntersectAny(const Scene*, const Ray3D*);
boolean   GelIntersectAny(const Gel*, const Ray3D*);
RGBColor  Shade(const Scene*, const IntersectionRecord*, unsigned);
boolean   BVHIntersectFront(const BoundingVolumeHierarchy*, const Ray3D*,
    IntersectionRecord*);


#endif
