/*

 MPIIntrinsics.h

 Copyright (c) 2006-2007, Lucas Stephen Beeler and Jeremy Wagner-Kaiser.
 All Rights Reserved.

 */

#ifndef  MPI_INTRINSICS__H
#define  MPI_INTRINSICS__H

#include <mpi.h>
#include "ApplicationServices.h"
#include "GeometryIntrinsics.h"
#include "Imaging.h"

#define kMaxPacketSize 800

/****  TYPE: NodeKind         ************************************************/
typedef  int  NodeKind;
enum { kWorkerKind, kManagerKind };
enum { kUnknown = -1 };
enum { kNullProcessor = -1 };




/****  TYPE: OperationCode    ************************************************/
typedef  int  OperationCode;
enum { kAccumulateWork, kAccumulateResult, kNotifyWorkBroadcastComplete,
       kNotifyWorkComplete, kNullOpcode };



/****  TYPE: MessageID *******************************************************/
typedef  int  MessageID;
enum { kWorkBroadcastMessage = 0, kProbeQuery = 1024, kProbeResultImmediate = 1025,
       kProbeResultStatus = 1026, kProbePartnerAcknowledge = 1027,
       kProbeWorkTransfer = 1028 };


/****  TYPE: NodeDescriptor   ************************************************/
struct NodeDescriptor_REP {

    int      nodeKind;
    int      numNodes;
    int      nodePID;
    boolean  isMPIInitialized;

};
typedef struct NodeDescriptor_REP NodeDescriptor;

void  PrintNodeDescriptor(const NodeDescriptor*);




struct WorkPacket_REP {

    OperationCode   opcode;
    Ray3D           rayData[kMaxPacketSize];
    unsigned        numRays;
    unsigned        pixelIDs[kMaxPacketSize];
    int             sourcePID;
};

typedef struct WorkPacket_REP WorkPacket;

void  MakeWorkPacketEmpty(WorkPacket*);
void  AddRayToWorkPacket(WorkPacket*, const Ray3D*, unsigned);
void  PrintWorkPacket(const WorkPacket*);



struct ResultPacket_REP {

    OperationCode  opcode;
    RGBColor       colorData[kMaxPacketSize];
    unsigned       numColors;
    unsigned       pixelIDs[kMaxPacketSize];
    int            sourcePID;
};

typedef struct ResultPacket_REP ResultPacket;

void  MakeResultPacketEmpty(ResultPacket*);
void  AddColorToResultPacket(ResultPacket*, const RGBColor*, unsigned);
void  PrintResultPacket(const ResultPacket*);




struct  WorkQueueElement_REP {

    Ray3D        ray;
    int          pixelID;
};
typedef struct WorkQueueElement_REP WorkQueueElement;

struct  WorkQueue_REP {

    WorkQueueElement*    data;
    int                  headIndex;
    int                  tailIndex;
    int                  slotsAllocated;
};
typedef struct WorkQueue_REP WorkQueue;

WorkQueue*  CreateWorkQueue(void);
void  EnqueueWork(WorkQueue*, const WorkQueueElement*);
WorkQueueElement  DequeueWork(WorkQueue*);
WorkQueueElement  PeekAtWorkQueueHead(const WorkQueue*);
boolean  IsWorkQueueEmpty(const WorkQueue*);
int  WorkQueueSize(const WorkQueue*);




struct  WorkPacketQueueElem_REP {

    WorkPacket   workPack;
};
typedef struct WorkPacketQueueElem_REP WorkPacketQueueElem;

struct  WorkPacketQueue_REP {

    WorkPacketQueueElem*    data;
    int                     headIndex;
    int                     tailIndex;
    int                     slotsAllocated;
};
typedef struct WorkPacketQueue_REP WorkPacketQueue;

WorkPacketQueue*  CreateWorkPacketQueue(void);
void  EnqueueWorkPacket(WorkPacketQueue*, const WorkPacketQueueElem*);
WorkPacketQueueElem  DequeueWorkPacket(WorkPacketQueue*);
WorkPacketQueueElem  PeekAtWorkPacketQueueHead(const WorkPacketQueue*);
boolean  IsWorkPacketQueueEmpty(const WorkPacketQueue*);




struct  ResultPacketQueueElem_REP {

    ResultPacket     resultPack;
};
typedef struct ResultPacketQueueElem_REP ResultPacketQueueElem;

struct  ResultPacketQueue_REP {

    ResultPacketQueueElem*  data;
    int                     headIndex;
    int                     tailIndex;
    int                     slotsAllocated;
};
typedef struct ResultPacketQueue_REP ResultPacketQueue;

ResultPacketQueue*  CreateResultPacketQueue(void);
void  EnqueueResultPacket(ResultPacketQueue*, const ResultPacketQueueElem*);
ResultPacketQueueElem  DequeueResultPacket(ResultPacketQueue*);
ResultPacketQueueElem  PeekAtResultPacketQueueHead(const ResultPacketQueue*);
boolean  IsResultPacketQueueEmpty(const ResultPacketQueue*);



struct  ResultBuffer_REP {

    int         numPixels;
    RGBColor*   colorData;
};
typedef  struct  ResultBuffer_REP  ResultBuffer;

ResultBuffer*   ConstructResultBufferForImage(const Image*);
void            CompositeToResultBuffer(ResultBuffer*, int, const RGBColor*);
void            FoldResultBufferToImage(Image*, const ResultBuffer*);




typedef  boolean*  WorkerStatusArray;

WorkerStatusArray  CreateWorkerStatusArray(void);
boolean            AreAllWorkersDone(const WorkerStatusArray);
void               MarkWorkerDone(WorkerStatusArray, int);
void               PrintWorkerStatusArray(const WorkerStatusArray);




struct  NodeProbeQueryPacket_REP {

    int  sourcePID;
};
typedef struct NodeProbeQueryPacket_REP NodeProbeQueryPacket;




struct  NodeProbeStatusPacket_REP {

    int       sourcePID;
    boolean   wantsRebalance;
    int       raysInFlight;
};
typedef struct NodeProbeStatusPacket_REP NodeProbeStatusPacket;




/***** NON-TYPE FUNCTIONS ****************************************************/
void  InitializeMPIEnvironment(int*, char***);
void  RandomPermutation(int*, int);
int   NextWorkerNode(int);
int   PreviousWorkerNode(int);


/***** MODULE-PUBLIC GLOBAL VARIABLES ****************************************/
extern NodeDescriptor gNodeInfo;

#endif
