/*

 Imaging.h

 Copyright (c) 2006-2007, Lucas Stephen Beeler. All Rights Reserved.

 */

#include "ApplicationServices.h"
#include "GeometryIntrinsics.h"

#ifndef  IMAGING__H
#define  IMAGING__H

typedef int ImageKind;
enum { kImageTrueRGBKind, kImageTrueRGBAKind };

struct  Image_Rep {

    unsigned         pixelWidth;
    unsigned         pixelHeight;
    unsigned char*   pixelData;
    ImageKind        kind;
    int              pixelDepth;
};
typedef struct Image_Rep Image;

Image*  ConstructImage(ImageKind, unsigned, unsigned, int);
void    WriteImagePixel(Image*, unsigned, unsigned, const RGBColor*);
void    SaveImage(Image*, const char*);

#endif
