/*

 main.c

 Copyright (c) 2006-2007, Lucas Stephen Beeler and Jeremy Wagner-Kaiser.
 All Rights Reserved.

 */

#include "ApplicationServices.h"
#include "GeometryIntrinsics.h"
#include "ObjectInput.h"
#include "Imaging.h"
#include "SceneIntrinsics.h"
#include "RayEngine.h"
#include "SceneGenerators.h"
#include "LightingIntrinsics.h"
#include "MPIIntrinsics.h"
#include "ManagerPersonality.h"
#include "WorkerPersonality.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

int main(int argc, char** argv)
{
    double  traceStartTime;
    double  traceStopTime;
    double  traceElapsedTime;

    InitializeMPIEnvironment(&argc, &argv);

    traceStartTime = MPI_Wtime( );

    if (gNodeInfo.nodeKind == kManagerKind) {

        printf("RENDERING START: rendering image on %d worker nodes.\n",
            (gNodeInfo.numNodes - 1));

        RunManagerPersonalityLoop( );
    }
    else {

        RunWorkerPersonalityLoop( );
    }

    MPI_Barrier(MPI_COMM_WORLD);

    traceStopTime = MPI_Wtime( );

    traceElapsedTime = (traceStopTime - traceStartTime);

    if (gNodeInfo.nodeKind == kManagerKind) {

        printf("RENDERING COMPLETE: trace time = %f seconds.\n",
            traceElapsedTime);
    }

    MPI_Finalize( );

    return 0;
}
