/*

 SpatialPartitioning.h

 Copyright (c) 2007, Lucas Stephen Beeler. All Rights Reserved.

 */

#ifndef  SPATIAL_PARTITIONING__H
#define  SPATIAL_PARTITIONING__H

#include "GeometryIntrinsics.h"
#include "Mesh.h"

enum { kSpliceOnX = 0, kSpliceOnY = 1, kSpliceOnZ = 2 };
typedef int SpliceAxisID;

enum { kNullFace = -1 };

struct  BVHNode_REP {

    BoundingBox3D         bounds;
    struct  BVHNode_REP*  rightChild;
    struct  BVHNode_REP*  leftChild;
    Mesh*                 hostMesh;
    int                   faceID;
};

typedef struct BVHNode_REP BVHNode;

struct  BoundingVolumeHierarchy_REP {

    BVHNode*   rootNode;
};

typedef struct BoundingVolumeHierarchy_REP BoundingVolumeHierarchy;

BoundingVolumeHierarchy*  ConstructBVH(const Mesh*, SpliceAxisID);

#endif
