/*

 ObjectInput.c

 Copyright (c) 2006, Lucas Stephen Beeler. All Rights Reserved.

 */

#include "ObjectInput.h"

Mesh*  ReadObjectData(FILE* inputFile)
{
    char         currentLine[1024];
    Mesh*        result = ConstructMesh(kVertexNormalMode);
    int          normalCounter = 0;
    boolean      sawVN = FALSE;
    
    result->isTriangleMesh = TRUE;

    while (fgets(currentLine, 1023, inputFile)) {

        char*  targetChar = strchr(currentLine, '#');
        char   controlType[1024];

        if (targetChar) {

            *targetChar = '\0';
        }

        sscanf(currentLine, "%s", controlType);

        if (!strcmp("v", controlType)) {

            HomogeneousVector3D  inVec;

            sscanf(currentLine, "%*s %lf %lf %lf", &inVec.x, &inVec.y,
                &inVec.z);

            inVec.w = 1.0;

            AppendVertex(result, &inVec);
        }
        else if (!strcmp("f", controlType)) {

            int     faceList[1024];
            int     counter = 0;
            char*   activeToken;
            int     numVertsInFace = 0;

            strtok(currentLine, " ");

            while (activeToken = strtok(0, " \n\r")) {

                faceList[counter] = (atoi(activeToken) - 1);

                counter++;
                numVertsInFace++;
            }

            if (numVertsInFace > 3) {

                result->isTriangleMesh = FALSE;
            }            

            AppendFace(result, faceList, counter);
        }
        else if (!strcmp("vn", controlType)) {

            HomogeneousVector3D  inNormal;

            sscanf(currentLine, "%*s %lf %lf %lf", &inNormal.x, &inNormal.y,
                &inNormal.z);

            inNormal.w = 0.0;

            sawVN = TRUE;

            SetVertexNormal(result, normalCounter, &inNormal);

            normalCounter++;
        }
    }

    if (!sawVN) {

        result->normalMode = kFaceNormalMode;
        free(result->normals);
        result->normals = 0;
    }

    return result;
}
