/*

 Mesh.h

 Copyright (c) 2006, Lucas Stephen Beeler. All Rights Reserved.

 */

#ifndef  MESH__H
#define  MESH__H

#include "ApplicationServices.h"
#include "GeometryIntrinsics.h"
#include <memory.h>
#include <string.h>

enum { kVertexNormalMode, kFaceNormalMode };
typedef int MeshNormalMode;

struct MeshFace_Rep {

    HomogeneousVector3D*   normal;
    int*                   vindexes;
    int                    numVindexes;
};
typedef struct MeshFace_Rep MeshFace;


struct Mesh_Rep {

    HomogeneousVector3D*  vertices;
    HomogeneousVector3D*  normals;
    int                   numVertices;
    int                   vertexSlotsAllocd;
    MeshFace*             faces;
    int                   numFaces;
    int                   faceSlotsAllocd;
    MeshNormalMode        normalMode;
    boolean               isTriangleMesh;
};
typedef struct Mesh_Rep Mesh;

void           AppendVertex(Mesh*, const HomogeneousVector3D*);
void           SetVertexNormal(Mesh*, int, const HomogeneousVector3D*);
void           AppendFace(Mesh*, const int*, int);
Mesh*          ConstructMesh(MeshNormalMode);
void           PrintMesh(const Mesh*);
BoundingBox3D  ComputeTriMeshBoundingBox(const Mesh*);

#endif
