/*

 LightingIntrinsics.h

 Copyright (c) 2006, Lucas Stephen Beeler. All Rights Reserved.

 */

#ifndef LIGHTING_INTRINSICS__H
#define LIGHTING_INTRINSICS__H

#include "GeometryIntrinsics.h"

enum { kPointLight, kGlobeLight };
typedef unsigned int LightKind;


typedef   void*  LightPersonalityPointer;

typedef   HomogeneousVector3D (*LPSampleFunction)(const HomogeneousVector3D*,
    const HomogeneousVector3D*, LightPersonalityPointer);

struct  Light_REP {

    LightKind                    kind;
    HomogeneousVector3D          origin;
    RGBColor                     color;
    LPSampleFunction             sampleFunction;
    LightPersonalityPointer      personality;
};
typedef struct Light_REP Light;

void  ConfigurePointLight(Light*, const RGBColor*, const HomogeneousVector3D*);
void  ConfigureGlobeLight(Light*, const RGBColor*, const HomogeneousVector3D*,
    double);
HomogeneousVector3D  SampleLightPosition(const Light*,
    const HomogeneousVector3D*);
void  PrintLight(const Light*);

#endif
