/*

 Imaging.c

 Copyright (c) 2006-2007, Lucas Stephen Beeler. All Rights Reserved.

 */

#include "Imaging.h"
#include "libtarga.h"
#include <stdlib.h>

Image*  ConstructImage(ImageKind userKind, unsigned userWidth,
    unsigned userHeight, int userDepth)
{
    Image*  result = malloc(sizeof(Image));

    result->pixelWidth = userWidth;
    result->pixelHeight = userHeight;
    result->pixelDepth = userDepth;
    result->kind = userKind;

    /* right now, we're just supporting RGB24 */
    result->pixelData = malloc(3 * userWidth * userHeight);

    return result;
}




void    WriteImagePixel(Image* target, unsigned pixelX, unsigned pixelY,
    const RGBColor* writeColor)
{
    unsigned         byteOffset = 0;
    unsigned char    r, g, b;

    if ((pixelX >= target->pixelWidth) || (pixelY >= target->pixelHeight))
        LogicError("WriteImagePixel( )", "pixel coords out of range");

    byteOffset = ((pixelY * target->pixelWidth) + pixelX) * 3;

    r = (unsigned char) ((writeColor->r) * 255);
    g = (unsigned char) ((writeColor->g) * 255);
    b = (unsigned char) ((writeColor->b) * 255);

    target->pixelData[byteOffset] = r;
    target->pixelData[byteOffset + 1] = g;
    target->pixelData[byteOffset + 2] = b;
}




void    SaveImage(Image* target, const char* filename)
{
    int resultCode;

    resultCode = tga_write_raw(filename, target->pixelWidth,
        target->pixelHeight, target->pixelData, TGA_TRUECOLOR_24);

    if (!resultCode)
        RuntimeError("SaveImage( )", "couldn't write output image");
}
