/*

 Camera.h

 Copyright (c) 2006, Lucas Stephen Beeler. All Rights Reserved.

 */

#ifndef  CAMERA__H
#define  CAMERA__H

#include "ApplicationServices.h"
#include "GeometryIntrinsics.h"

struct Camera_Rep {

    HomogeneousVector3D    origin;
    HomogeneousVector3D    eyeSpaceX;
    HomogeneousVector3D    eyeSpaceY;
    HomogeneousVector3D    eyeSpaceZ;
    double                 fovy;
    double                 imageXSize;
    double                 imageYSize;
    double                 imagePlaneDistance;
};

typedef struct Camera_Rep Camera;

void  SetCamera(Camera*, const HomogeneousVector3D*, const HomogeneousVector3D*,
    const HomogeneousVector3D*, double, double, double, double);

#endif
