/*

 Camera.c

 Copyright (c) 2006, Lucas Stephen Beeler. All Rights Reserved.

 */

#include "Camera.h"

void  SetCamera(Camera* target, const HomogeneousVector3D* userOrigin,
    const HomogeneousVector3D* userGaze, const HomogeneousVector3D* userUp,
    double userFovy, double userImX, double userImY, double ipd)
{
    
    HomogeneousVector3D     tempX, tempY;

    target->origin      = *userOrigin;
    target->eyeSpaceZ   = VectorNormalize(userGaze);
    target->eyeSpaceZ   = ScalarMultiply(&target->eyeSpaceZ, -1.0);
    
    tempX = VectorCross(userUp, &target->eyeSpaceZ);
    tempY = VectorCross(&target->eyeSpaceZ, &tempX);

    target->eyeSpaceX = VectorNormalize(&tempX);
    target->eyeSpaceY = VectorNormalize(&tempY);

    target->fovy = userFovy;
    target->imageXSize = userImX;
    target->imageYSize = userImY;
    target->imagePlaneDistance = ipd;
}
