/*

 ApplicationServices.c

 Implements functions in the Application Services Module; functions in
 this module support various facilities of use to client programmers,
 such as diagnostics, stylized error handling, etc.
 etc.

 Copyright (c) 2006, Lucas Stephen Beeler. All Rights Reserved.

 */

#include "ApplicationServices.h"
#include <stdio.h>
#include <stdlib.h>

void  LogicError(const char* failLocation, const char* failMsg)
{
    printf("\nlogic error @ %s: %s.\n", failLocation, failMsg);
    exit(-1);
}



void  RuntimeError(const char* failLocation, const char* failMsg)
{
    printf("\nruntime error @ %s: %s.\n", failLocation, failMsg);
    exit(-1);
}


void  RuntimeWarning(const char* warnLocation, const char* warnMsg)
{
    printf("\nruntime warning @ %s: %s.\n", warnLocation, warnMsg);
}
